/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json;

import dev.runefox.json.JsonInput;
import dev.runefox.json.JsonNode;
import dev.runefox.json.JsonOutput;
import dev.runefox.json.JsonParsingConfig;
import dev.runefox.json.JsonSerializingConfig;
import dev.runefox.json.SerializationException;
import dev.runefox.json.impl.JsonInputImpl;
import dev.runefox.json.impl.JsonOutputImpl;
import dev.runefox.json.impl.Serializer;
import dev.runefox.json.impl.parse.json.Json5Lexer;
import dev.runefox.json.impl.parse.json.JsonLexer;
import dev.runefox.json.impl.parse.json.JsonLexerReader;
import dev.runefox.json.impl.parse.json.JsonParser;
import dev.runefox.json.impl.parse.json.JsonReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public class Json {
    private static final JsonSerializingConfig DEFAULT_FORMAT_CONFIG = JsonSerializingConfig.pretty();
    private static final JsonParsingConfig DEFAULT_PARSE_CONFIG = JsonParsingConfig.standard();
    private static final JsonSerializingConfig JSON5_FORMAT_CONFIG = JsonSerializingConfig.pretty().json5(true);
    private static final JsonParsingConfig JSON5_PARSE_CONFIG = JsonParsingConfig.standard().json5(true);
    private static final Json JSON = new Json(false);
    private static final Json JSON5 = new Json(true);
    private static final Json COMPACT_JSON = Json.jsonBuilder().serializationConfig(JsonSerializingConfig.compact()).build();
    private static final Json COMPACT_JSON5 = Json.json5Builder().serializationConfig(JsonSerializingConfig.compact()).build();
    private final JsonSerializingConfig formatConfig;
    private final JsonParsingConfig parseConfig;
    private final ThreadLocal<StringBuilder> toStringBuilder = ThreadLocal.withInitial(StringBuilder::new);

    private Json(Builder builder) {
        this.formatConfig = builder.formatConfig.copy();
        this.parseConfig = builder.parseConfig.copy();
    }

    private Json(boolean j5) {
        this.formatConfig = j5 ? JSON5_FORMAT_CONFIG : DEFAULT_FORMAT_CONFIG;
        this.parseConfig = j5 ? JSON5_PARSE_CONFIG : DEFAULT_PARSE_CONFIG;
    }

    private JsonReader createReader(Reader reader) throws IOException {
        if (this.parseConfig.json5()) {
            return new JsonLexerReader(new Json5Lexer(reader), this.parseConfig.allowNonExecutePrefix());
        }
        return new JsonLexerReader(new JsonLexer(reader), this.parseConfig.allowNonExecutePrefix());
    }

    public JsonNode parse(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException();
        }
        return JsonParser.parse(this.createReader(reader), this.parseConfig);
    }

    public JsonNode parse(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.parse(new StringReader(string));
    }

    public JsonNode parse(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return this.parse(new InputStreamReader(stream));
    }

    public JsonNode parse(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonNode jsonNode = this.parse(reader);
            return jsonNode;
        }
    }

    public JsonInput input(Reader reader) throws IOException {
        if (reader == null) {
            throw new NullPointerException();
        }
        return new JsonInputImpl(this.createReader(reader), this.parseConfig);
    }

    public JsonInput input(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.input(new StringReader(string));
    }

    public JsonInput input(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        return this.input(new InputStreamReader(stream));
    }

    public JsonInput input(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        return this.input(reader);
    }

    public void serialize(JsonNode node, Writer writer) throws IOException {
        if (node == null || writer == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        Serializer.serialize(node, writer, this.formatConfig);
    }

    public void serialize(JsonNode node, OutputStream stream) throws IOException {
        if (node == null || stream == null) {
            throw new NullPointerException();
        }
        this.serialize(node, new OutputStreamWriter(stream));
    }

    public void serialize(JsonNode node, File file) throws IOException {
        if (node == null || file == null) {
            throw new NullPointerException();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.serialize(node, writer);
        }
    }

    public void serialize(JsonNode node, StringBuilder builder) throws SerializationException {
        if (node == null || builder == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        try {
            Serializer.serialize(node, builder, this.formatConfig);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError((Object)"StringBuilder throws IOException?!");
        }
    }

    public String serialize(JsonNode node) throws SerializationException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.formatConfig.anyValue()) {
            node.requireConstruct();
        }
        StringBuilder builder = this.toStringBuilder.get();
        builder.setLength(0);
        this.serialize(node, builder);
        return builder.toString();
    }

    public JsonOutput output(Writer writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        return new JsonOutputImpl(writer, writer, writer, this.formatConfig);
    }

    public JsonOutput output(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        return this.output(new OutputStreamWriter(stream));
    }

    public JsonOutput output(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        return this.output(writer);
    }

    public JsonOutput output(StringBuilder builder) {
        if (builder == null) {
            throw new NullPointerException();
        }
        return new JsonOutputImpl(builder, () -> {}, () -> {}, this.formatConfig);
    }

    public static Builder jsonBuilder() {
        return new Builder();
    }

    public static Builder json5Builder() {
        return new Builder().serializationConfig(JSON5_FORMAT_CONFIG).parseConfig(JSON5_PARSE_CONFIG);
    }

    public static Json json() {
        return JSON;
    }

    public static Json json5() {
        return JSON5;
    }

    public static Json compactJson() {
        return COMPACT_JSON;
    }

    public static Json compactJson5() {
        return COMPACT_JSON5;
    }

    public static class Builder {
        private JsonSerializingConfig formatConfig = DEFAULT_FORMAT_CONFIG;
        private JsonParsingConfig parseConfig = DEFAULT_PARSE_CONFIG;

        private Builder() {
        }

        public Builder serializationConfig(JsonSerializingConfig config) {
            if (config == null) {
                throw new NullPointerException();
            }
            this.formatConfig = config;
            return this;
        }

        public Builder parseConfig(JsonParsingConfig config) {
            if (config == null) {
                throw new NullPointerException();
            }
            this.parseConfig = config;
            return this;
        }

        public Json build() {
            return new Json(this);
        }
    }
}

