/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeException;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import dev.runefox.json.codec.NoCodecImplementation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

class AlternativesCodec<A>
implements JsonCodec<A> {
    private final List<JsonCodec<A>> options;

    AlternativesCodec(List<JsonCodec<A>> options) {
        this.options = options;
    }

    @Override
    public JsonNode encode(A obj) {
        ArrayList<NodeException> exceptions = null;
        for (JsonCodec<A> codec : this.options) {
            try {
                return codec.encode(obj);
            }
            catch (NoCodecImplementation noCodecImplementation) {
            }
            catch (NodeException exc) {
                if (exceptions == null) {
                    exceptions = new ArrayList<NodeException>();
                }
                exceptions.add(exc);
            }
        }
        if (exceptions == null) {
            throw new CodecException("Could not encode");
        }
        if (exceptions.size() == 1) {
            throw (NodeException)exceptions.get(0);
        }
        CodecException exc = new CodecException("Could not encode");
        exceptions.forEach(exc::addSuppressed);
        throw exc;
    }

    @Override
    public A decode(JsonNode json) {
        ArrayList<NodeException> exceptions = null;
        for (JsonCodec<A> codec : this.options) {
            try {
                return codec.decode(json);
            }
            catch (NoCodecImplementation noCodecImplementation) {
            }
            catch (NodeException exc) {
                if (exceptions == null) {
                    exceptions = new ArrayList<NodeException>();
                }
                exceptions.add(exc);
            }
        }
        if (exceptions == null) {
            throw new CodecException("Could not decode");
        }
        if (exceptions.size() == 1) {
            throw (NodeException)exceptions.get(0);
        }
        CodecException exc = new CodecException("Could not decode");
        exceptions.forEach(exc::addSuppressed);
        throw exc;
    }

    @Override
    public JsonCodec<A> alternatively(JsonCodec<A> option) {
        return new AlternativesCodec<A>(List.copyOf(Stream.concat(this.options.stream(), Stream.of(option)).toList()));
    }
}

