/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;

class ComparableInCodec<A extends Comparable<? super A>>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A min;
    private final A max;

    ComparableInCodec(JsonCodec<A> codec, A min, A max) {
        this.codec = codec;
        this.min = min;
        this.max = max;
        if (max.compareTo(min) < 0) {
            throw new IllegalArgumentException("max < min");
        }
    }

    private A check(A a) {
        if (a.compareTo(this.min) < 0 || a.compareTo(this.max) > 0) {
            throw new CodecException("Value " + a + " out of range [" + this.min + ", " + this.max + "]");
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return (A)this.check((Comparable)this.codec.decode(json));
    }
}

