/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import java.util.Comparator;

class ComparatorInCodec<A>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A min;
    private final A max;
    private final Comparator<? super A> comp;

    ComparatorInCodec(JsonCodec<A> codec, A min, A max, Comparator<? super A> comp) {
        this.codec = codec;
        this.min = min;
        this.max = max;
        this.comp = comp;
        if (comp.compare(max, min) < 0) {
            throw new IllegalArgumentException("max < min");
        }
    }

    private A check(A a) {
        if (this.comp.compare(a, this.min) < 0 || this.comp.compare(a, this.max) > 0) {
            throw new CodecException("Value " + a + " out of range [" + this.min + ", " + this.max + "]");
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return this.check(this.codec.decode(json));
    }
}

