/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import java.util.Comparator;

class ComparatorUnderCodec<A>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A max;
    private final Comparator<? super A> comp;

    ComparatorUnderCodec(JsonCodec<A> codec, A max, Comparator<? super A> comp) {
        this.codec = codec;
        this.max = max;
        this.comp = comp;
    }

    private A check(A a) {
        if (this.comp.compare(a, this.max) > 0) {
            throw new CodecException("Value " + a + " above limit " + this.max);
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return this.check(this.codec.decode(json));
    }
}

