/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeException;
import dev.runefox.json.NodeType;
import dev.runefox.json.codec.AlternativesCodec;
import dev.runefox.json.codec.BasicCodec;
import dev.runefox.json.codec.CheckCodec;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.ComparableAboveCodec;
import dev.runefox.json.codec.ComparableInCodec;
import dev.runefox.json.codec.ComparableUnderCodec;
import dev.runefox.json.codec.ComparatorAboveCodec;
import dev.runefox.json.codec.ComparatorInCodec;
import dev.runefox.json.codec.ComparatorUnderCodec;
import dev.runefox.json.codec.EncodableCodec;
import dev.runefox.json.codec.EnumCodec;
import dev.runefox.json.codec.JsonEncodable;
import dev.runefox.json.codec.ListCodec;
import dev.runefox.json.codec.MapCodec;
import dev.runefox.json.codec.MappedCodec;
import dev.runefox.json.codec.NoCodecImplementation;
import dev.runefox.json.codec.SetCodec;
import dev.runefox.json.codec.TemporalCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public interface JsonCodec<A> {
    public static final JsonCodec<JsonNode> JSON_NODE = JsonCodec.of(Function.identity(), Function.identity());
    public static final JsonCodec<Byte> BYTE = JsonCodec.of(JsonNode::number, JsonNode::asByte);
    public static final JsonCodec<Short> SHORT = JsonCodec.of(JsonNode::number, JsonNode::asShort);
    public static final JsonCodec<Integer> INT = JsonCodec.of(JsonNode::number, JsonNode::asInt);
    public static final JsonCodec<Long> LONG = JsonCodec.of(JsonNode::number, JsonNode::asLong);
    public static final JsonCodec<Float> FLOAT = JsonCodec.of(JsonNode::number, JsonNode::asFloat);
    public static final JsonCodec<Double> DOUBLE = JsonCodec.of(JsonNode::number, JsonNode::asDouble);
    public static final JsonCodec<byte[]> BYTE_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asByteArray);
    public static final JsonCodec<short[]> SHORT_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asShortArray);
    public static final JsonCodec<int[]> INT_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asIntArray);
    public static final JsonCodec<long[]> LONG_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asLongArray);
    public static final JsonCodec<float[]> FLOAT_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asFloatArray);
    public static final JsonCodec<double[]> DOUBLE_ARRAY = JsonCodec.of(JsonNode::numberArray, JsonNode::asDoubleArray);
    public static final JsonCodec<BigInteger> BIG_INTEGER = JsonCodec.of(JsonNode::number, JsonNode::asBigInteger);
    public static final JsonCodec<BigDecimal> BIG_DECIMAL = JsonCodec.of(JsonNode::number, JsonNode::asBigDecimal);
    public static final JsonCodec<Boolean> BOOLEAN = JsonCodec.of(JsonNode::bool, JsonNode::asBoolean);
    public static final JsonCodec<boolean[]> BOOLEAN_ARRAY = JsonCodec.of(JsonNode::boolArray, JsonNode::asBooleanArray);
    public static final JsonCodec<String> STRING = JsonCodec.of(JsonNode::string, JsonNode::asString);
    public static final JsonCodec<String> EXACT_STRING = JsonCodec.of(JsonNode::string, JsonNode::asExactString);
    public static final JsonCodec<Character> CHAR = JsonCodec.of(ch -> JsonNode.string(ch.toString()), json -> {
        json.require(NodeType.NUMBER, NodeType.STRING);
        if (json.isString()) {
            String str = json.asExactString();
            if (str.length() != 1) {
                throw new CodecException("Character expected, string length must be 1");
            }
            return Character.valueOf(str.charAt(0));
        }
        int i = json.asInt();
        if (i < 0 || i > 65535) {
            throw new CodecException("Character expected, unicode value must be between 0 and \uffff");
        }
        return Character.valueOf((char)i);
    });
    public static final JsonCodec<Integer> CODE_POINT = JsonCodec.of(ch -> JsonNode.string(new String(new int[]{ch}, 0, 1)), json -> {
        json.require(NodeType.NUMBER, NodeType.STRING);
        if (json.isString()) {
            String str = json.asExactString();
            if (str.codePointCount(0, str.length()) != 1) {
                throw new CodecException("Unicode code point expected, string length must be 1 code point");
            }
            return str.codePointAt(0);
        }
        int i = json.asInt();
        if (i < 0 || i > 0x10FFFF) {
            throw new CodecException("Unicode code point expected, unicode value must be between 0 and 1114111");
        }
        return i;
    });
    public static final JsonCodec<UUID> UUID = JsonCodec.of(uuid -> JsonNode.string(uuid.toString()), JsonCodec.wrapExceptions(json -> java.util.UUID.fromString(json.asString())));
    public static final JsonCodec<Instant> INSTANT = JsonCodec.instant(DateTimeFormatter.ISO_INSTANT);
    public static final JsonCodec<LocalDate> LOCAL_DATE = JsonCodec.localDate(DateTimeFormatter.ISO_LOCAL_DATE);
    public static final JsonCodec<LocalDateTime> LOCAL_DATE_TIME = JsonCodec.localDateTime(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    public static final JsonCodec<LocalTime> LOCAL_TIME = JsonCodec.localTime(DateTimeFormatter.ISO_LOCAL_TIME);
    public static final JsonCodec<OffsetDateTime> OFFSET_DATE_TIME = JsonCodec.offsetDateTime(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    public static final JsonCodec<OffsetTime> OFFSET_TIME = JsonCodec.offsetTime(DateTimeFormatter.ISO_OFFSET_TIME);
    public static final JsonCodec<Year> YEAR = JsonCodec.alternatives(JsonCodec.year(TemporalCodec.YEAR_FMT), JsonCodec.of(yr -> JsonNode.number(yr.getValue()), JsonCodec.wrapExceptions(node -> Year.of(node.asInt()))));
    public static final JsonCodec<Month> MONTH = JsonCodec.alternatives(JsonCodec.month(TemporalCodec.MONTH_FMT), JsonCodec.of(yr -> JsonNode.number(yr.getValue()), JsonCodec.wrapExceptions(node -> Month.of(node.asInt()))));
    public static final JsonCodec<YearMonth> YEAR_MONTH = JsonCodec.yearMonth(TemporalCodec.YEAR_MONTH_FMT);
    public static final JsonCodec<MonthDay> MONTH_DAY = JsonCodec.monthDay(TemporalCodec.MONTH_DAY_FMT);
    public static final JsonCodec<ZonedDateTime> ZONED_DATE_TIME = JsonCodec.zonedDateTime(DateTimeFormatter.ISO_ZONED_DATE_TIME);

    public JsonNode encode(A var1);

    public A decode(JsonNode var1);

    public static <E extends JsonEncodable> JsonCodec<E> ofEncodable(Function<JsonNode, E> instanceFactory) {
        return new EncodableCodec<E>(instanceFactory);
    }

    public static <E extends JsonEncodable> JsonCodec<E> ofEncodable(Supplier<E> instanceFactory) {
        return new EncodableCodec<JsonEncodable>(json -> (JsonEncodable)instanceFactory.get());
    }

    @SafeVarargs
    public static <A> JsonCodec<A> alternatives(JsonCodec<A> ... options) {
        return new AlternativesCodec<A>(List.of(options));
    }

    default public JsonCodec<A> alternatively(JsonCodec<A> option) {
        return JsonCodec.alternatives(this, option);
    }

    public static <A, N> JsonCodec<A> map(JsonCodec<N> codec, Function<N, A> map, Function<A, N> unmap) {
        return new MappedCodec<A, N>(codec, map, unmap);
    }

    default public <N> JsonCodec<N> map(Function<A, N> map, Function<N, A> unmap) {
        return JsonCodec.map(this, map, unmap);
    }

    public static <A> JsonCodec<A> of(Function<A, JsonNode> encode, Function<JsonNode, A> decode) {
        return new BasicCodec<A>(encode, decode);
    }

    public static <A> JsonCodec<A> encodeOnly(Function<A, JsonNode> encode) {
        return new BasicCodec<Object>(encode, node -> {
            throw new NoCodecImplementation();
        });
    }

    public static <A> JsonCodec<A> decodeOnly(Function<JsonNode, A> decode) {
        return new BasicCodec<Object>(obj -> {
            throw new NoCodecImplementation();
        }, decode);
    }

    public static <A, B> Function<A, B> wrapExceptions(Function<A, B> fn) {
        return a -> {
            try {
                return fn.apply(a);
            }
            catch (NodeException exc) {
                throw exc;
            }
            catch (Throwable thr) {
                throw new CodecException(thr.getMessage(), thr);
            }
        };
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec) {
        return new ListCodec<A>(elementCodec);
    }

    default public JsonCodec<List<A>> listOf() {
        return JsonCodec.listOf(this);
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec, int maxLen) {
        return new ListCodec<A>(elementCodec, maxLen);
    }

    default public JsonCodec<List<A>> listOf(int maxLen) {
        return JsonCodec.listOf(this, maxLen);
    }

    public static <A> JsonCodec<List<A>> listOf(JsonCodec<A> elementCodec, int minLen, int maxLen) {
        return new ListCodec<A>(elementCodec, minLen, maxLen);
    }

    default public JsonCodec<List<A>> listOf(int minLen, int maxLen) {
        return JsonCodec.listOf(this, minLen, maxLen);
    }

    public static <A> JsonCodec<Set<A>> setOf(JsonCodec<A> elementCodec) {
        return new SetCodec<A>(elementCodec);
    }

    default public JsonCodec<Set<A>> setOf() {
        return JsonCodec.setOf(this);
    }

    public static <A, K> JsonCodec<Map<K, A>> mapOf(JsonCodec<A> elementCodec, Function<K, String> keyToString, Function<String, K> stringToKey) {
        return new MapCodec<A, K>(elementCodec, JsonCodec.wrapExceptions(keyToString), JsonCodec.wrapExceptions(stringToKey));
    }

    default public <K> JsonCodec<Map<K, A>> mapOf(Function<K, String> keyToString, Function<String, K> stringToKey) {
        return JsonCodec.mapOf(this, keyToString, stringToKey);
    }

    public static <A> JsonCodec<Map<String, A>> mapOf(JsonCodec<A> elementCodec) {
        return new MapCodec(elementCodec, Function.identity(), Function.identity());
    }

    default public JsonCodec<Map<String, A>> mapOf() {
        return JsonCodec.mapOf(this);
    }

    public static JsonCodec<Byte> byteIn(byte min, byte max) {
        return new ComparableInCodec<Byte>(BYTE, min, max);
    }

    public static JsonCodec<Byte> byteUnder(byte max) {
        return new ComparableUnderCodec<Byte>(BYTE, max);
    }

    public static JsonCodec<Byte> byteAbove(byte min) {
        return new ComparableAboveCodec<Byte>(BYTE, min);
    }

    public static JsonCodec<Short> shortIn(short min, short max) {
        return new ComparableInCodec<Short>(SHORT, min, max);
    }

    public static JsonCodec<Short> shortUnder(short max) {
        return new ComparableUnderCodec<Short>(SHORT, max);
    }

    public static JsonCodec<Short> shortAbove(short min) {
        return new ComparableAboveCodec<Short>(SHORT, min);
    }

    public static JsonCodec<Integer> intIn(int min, int max) {
        return new ComparableInCodec<Integer>(INT, min, max);
    }

    public static JsonCodec<Integer> intUnder(int max) {
        return new ComparableUnderCodec<Integer>(INT, max);
    }

    public static JsonCodec<Integer> intAbove(int min) {
        return new ComparableAboveCodec<Integer>(INT, min);
    }

    public static JsonCodec<Long> longIn(long min, long max) {
        return new ComparableInCodec<Long>(LONG, min, max);
    }

    public static JsonCodec<Long> longUnder(long max) {
        return new ComparableUnderCodec<Long>(LONG, max);
    }

    public static JsonCodec<Long> longAbove(long min) {
        return new ComparableAboveCodec<Long>(LONG, min);
    }

    public static JsonCodec<Float> floatIn(float min, float max) {
        return new ComparableInCodec<Float>(FLOAT, Float.valueOf(min), Float.valueOf(max));
    }

    public static JsonCodec<Float> floatUnder(float max) {
        return new ComparableUnderCodec<Float>(FLOAT, Float.valueOf(max));
    }

    public static JsonCodec<Float> floatAbove(float min) {
        return new ComparableAboveCodec<Float>(FLOAT, Float.valueOf(min));
    }

    public static JsonCodec<Double> doubleIn(double min, double max) {
        return new ComparableInCodec<Double>(DOUBLE, min, max);
    }

    public static JsonCodec<Double> doubleUnder(double max) {
        return new ComparableUnderCodec<Double>(DOUBLE, max);
    }

    public static JsonCodec<Double> doubleAbove(double min) {
        return new ComparableAboveCodec<Double>(DOUBLE, min);
    }

    public static JsonCodec<BigInteger> bigIntegerIn(BigInteger min, BigInteger max) {
        return new ComparableInCodec<BigInteger>(BIG_INTEGER, min, max);
    }

    public static JsonCodec<BigInteger> bigIntegerUnder(BigInteger max) {
        return new ComparableUnderCodec<BigInteger>(BIG_INTEGER, max);
    }

    public static JsonCodec<BigInteger> bigIntegerAbove(BigInteger min) {
        return new ComparableAboveCodec<BigInteger>(BIG_INTEGER, min);
    }

    public static JsonCodec<BigDecimal> bigDecimalIn(BigDecimal min, BigDecimal max) {
        return new ComparableInCodec<BigDecimal>(BIG_DECIMAL, min, max);
    }

    public static JsonCodec<BigDecimal> bigDecimalUnder(BigDecimal max) {
        return new ComparableUnderCodec<BigDecimal>(BIG_DECIMAL, max);
    }

    public static JsonCodec<BigDecimal> bigDecimalAbove(BigDecimal min) {
        return new ComparableAboveCodec<BigDecimal>(BIG_DECIMAL, min);
    }

    public static <A extends Comparable<? super A>> JsonCodec<A> in(JsonCodec<A> codec, A min, A max) {
        return new ComparableInCodec<A>(codec, min, max);
    }

    public static <A extends Comparable<? super A>> JsonCodec<A> under(JsonCodec<A> codec, A max) {
        return new ComparableUnderCodec<A>(codec, max);
    }

    public static <A extends Comparable<? super A>> JsonCodec<A> above(JsonCodec<A> codec, A min) {
        return new ComparableAboveCodec<A>(codec, min);
    }

    public static <A> JsonCodec<A> in(JsonCodec<A> codec, A min, A max, Comparator<? super A> comp) {
        return new ComparatorInCodec<A>(codec, min, max, comp);
    }

    default public JsonCodec<A> in(A min, A max, Comparator<? super A> comp) {
        return JsonCodec.in(this, min, max, comp);
    }

    public static <A> JsonCodec<A> under(JsonCodec<A> codec, A max, Comparator<? super A> comp) {
        return new ComparatorUnderCodec<A>(codec, max, comp);
    }

    default public JsonCodec<A> under(A max, Comparator<? super A> comp) {
        return JsonCodec.under(this, max, comp);
    }

    public static <A> JsonCodec<A> above(JsonCodec<A> codec, A min, Comparator<? super A> comp) {
        return new ComparatorAboveCodec<A>(codec, min, comp);
    }

    default public JsonCodec<A> above(A min, Comparator<? super A> comp) {
        return JsonCodec.above(this, min, comp);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(E[] type, Function<E, String> namer) {
        return new EnumCodec(type, namer, e -> true);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnumIn(E[] type, Function<E, String> namer, E from, E to) {
        if (from == null && to == null) {
            return new EnumCodec(type, namer, e -> true);
        }
        if (from == null) {
            return new EnumCodec(type, namer, e -> e.compareTo(to) <= 0);
        }
        if (to == null) {
            return new EnumCodec(type, namer, e -> e.compareTo(from) >= 0);
        }
        return new EnumCodec(type, namer, e -> e.compareTo(from) >= 0 && e.compareTo(to) <= 0);
    }

    @SafeVarargs
    public static <E extends Enum<E>> JsonCodec<E> ofEnum(E[] type, Function<E, String> namer, E ... options) {
        HashSet<E> set = new HashSet<E>(Arrays.asList(options));
        return new EnumCodec(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(E[] type, Function<E, String> namer, Collection<? extends E> options) {
        HashSet<? extends E> set = new HashSet<E>(options);
        return new EnumCodec(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(E[] type, Function<E, String> namer, Predicate<E> check) {
        return new EnumCodec(type, namer, check);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer) {
        return new EnumCodec<Enum>(type, namer, e -> true);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnumIn(Class<E> type, Function<E, String> namer, E from, E to) {
        if (from == null && to == null) {
            return new EnumCodec<Enum>(type, namer, e -> true);
        }
        if (from == null) {
            return new EnumCodec<Enum>(type, namer, e -> e.compareTo(to) <= 0);
        }
        if (to == null) {
            return new EnumCodec<Enum>(type, namer, e -> e.compareTo(from) >= 0);
        }
        return new EnumCodec<Enum>(type, namer, e -> e.compareTo(from) >= 0 && e.compareTo(to) <= 0);
    }

    @SafeVarargs
    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, E ... options) {
        HashSet<E> set = new HashSet<E>(Arrays.asList(options));
        return new EnumCodec<Enum>(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, Collection<? extends E> options) {
        HashSet<? extends E> set = new HashSet<E>(options);
        return new EnumCodec<Enum>(type, namer, set::contains);
    }

    public static <E extends Enum<E>> JsonCodec<E> ofEnum(Class<E> type, Function<E, String> namer, Predicate<E> check) {
        return new EnumCodec<E>(type, namer, check);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, Function<A, String> error) {
        return new CheckCodec<A>(codec, predicate, error);
    }

    default public JsonCodec<A> check(Predicate<A> predicate, Function<A, String> error) {
        return JsonCodec.check(this, predicate, error);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, Supplier<String> error) {
        return new CheckCodec<Object>(codec, predicate, a -> (String)error.get());
    }

    default public JsonCodec<A> check(Predicate<A> predicate, Supplier<String> error) {
        return JsonCodec.check(this, predicate, error);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate, String error) {
        return new CheckCodec<Object>(codec, predicate, a -> error);
    }

    default public JsonCodec<A> check(Predicate<A> predicate, String error) {
        return JsonCodec.check(this, predicate, error);
    }

    public static <A> JsonCodec<A> check(JsonCodec<A> codec, Predicate<A> predicate) {
        return new CheckCodec<Object>(codec, predicate, a -> "Invalid value " + a);
    }

    default public JsonCodec<A> check(Predicate<A> predicate) {
        return JsonCodec.check(this, predicate);
    }

    public static JsonCodec<String> stringMatching(String pattern) {
        return JsonCodec.stringMatching(Pattern.compile(pattern));
    }

    public static JsonCodec<String> stringMatching(Pattern pattern) {
        return new CheckCodec<String>(STRING, str -> pattern.matcher((CharSequence)str).matches(), str -> "'" + str + "' does not match '" + pattern.pattern() + "'");
    }

    public static JsonCodec<String> string(int minLen, int maxLen) {
        return new CheckCodec<String>(STRING, str -> {
            int len = str.length();
            return len >= minLen && len <= maxLen;
        }, str -> "String '" + str + "' length is out of range [" + minLen + "," + maxLen + "]");
    }

    public static JsonCodec<String> string(int maxLen) {
        return new CheckCodec<String>(STRING, str -> {
            int len = str.length();
            return len <= maxLen;
        }, str -> "String '" + str + "' length is above limit " + maxLen);
    }

    public static <T extends TemporalAccessor> JsonCodec<T> temporal(DateTimeFormatter formatter, TemporalQuery<T> query) {
        return new TemporalCodec<T>(formatter, query);
    }

    public static <T extends TemporalAccessor & Comparable<T>> JsonCodec<T> temporalIn(DateTimeFormatter formatter, T min, T max, TemporalQuery<T> query) {
        return JsonCodec.in(new TemporalCodec<T>(formatter, query), min, max);
    }

    public static <T extends TemporalAccessor & Comparable<T>> JsonCodec<T> temporalAbove(DateTimeFormatter formatter, T min, TemporalQuery<T> query) {
        return JsonCodec.above(new TemporalCodec<T>(formatter, query), min);
    }

    public static <T extends TemporalAccessor & Comparable<T>> JsonCodec<T> temporalUnder(DateTimeFormatter formatter, T max, TemporalQuery<T> query) {
        return JsonCodec.under(new TemporalCodec<T>(formatter, query), max);
    }

    public static JsonCodec<Instant> instant(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, Instant::from);
    }

    public static JsonCodec<Instant> instantIn(DateTimeFormatter formatter, Instant min, Instant max) {
        return JsonCodec.in(JsonCodec.instant(formatter), min, max);
    }

    public static JsonCodec<Instant> instantAbove(DateTimeFormatter formatter, Instant min) {
        return JsonCodec.above(JsonCodec.instant(formatter), min);
    }

    public static JsonCodec<Instant> instantUnder(DateTimeFormatter formatter, Instant max) {
        return JsonCodec.under(JsonCodec.instant(formatter), max);
    }

    public static JsonCodec<Instant> instantIn(Instant min, Instant max) {
        return JsonCodec.in(INSTANT, min, max);
    }

    public static JsonCodec<Instant> instantAbove(Instant min) {
        return JsonCodec.above(INSTANT, min);
    }

    public static JsonCodec<Instant> instantUnder(Instant max) {
        return JsonCodec.under(INSTANT, max);
    }

    public static JsonCodec<LocalDate> localDate(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, LocalDate::from);
    }

    public static JsonCodec<LocalDate> localDateIn(DateTimeFormatter formatter, LocalDate min, LocalDate max) {
        return JsonCodec.in(JsonCodec.localDate(formatter), min, max);
    }

    public static JsonCodec<LocalDate> localDateAbove(DateTimeFormatter formatter, LocalDate min) {
        return JsonCodec.above(JsonCodec.localDate(formatter), min);
    }

    public static JsonCodec<LocalDate> localDateUnder(DateTimeFormatter formatter, LocalDate max) {
        return JsonCodec.under(JsonCodec.localDate(formatter), max);
    }

    public static JsonCodec<LocalDate> localDateIn(LocalDate min, LocalDate max) {
        return JsonCodec.in(LOCAL_DATE, min, max);
    }

    public static JsonCodec<LocalDate> localDateAbove(LocalDate min) {
        return JsonCodec.above(LOCAL_DATE, min);
    }

    public static JsonCodec<LocalDate> localDateUnder(LocalDate max) {
        return JsonCodec.under(LOCAL_DATE, max);
    }

    public static JsonCodec<LocalDateTime> localDateTime(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, LocalDateTime::from);
    }

    public static JsonCodec<LocalDateTime> localDateTimeIn(DateTimeFormatter formatter, LocalDateTime min, LocalDateTime max) {
        return JsonCodec.in(JsonCodec.localDateTime(formatter), min, max);
    }

    public static JsonCodec<LocalDateTime> localDateTimeAbove(DateTimeFormatter formatter, LocalDateTime min) {
        return JsonCodec.above(JsonCodec.localDateTime(formatter), min);
    }

    public static JsonCodec<LocalDateTime> localDateTimeUnder(DateTimeFormatter formatter, LocalDateTime max) {
        return JsonCodec.under(JsonCodec.localDateTime(formatter), max);
    }

    public static JsonCodec<LocalDateTime> localDateTimeIn(LocalDateTime min, LocalDateTime max) {
        return JsonCodec.in(LOCAL_DATE_TIME, min, max);
    }

    public static JsonCodec<LocalDateTime> localDateTimeAbove(LocalDateTime min) {
        return JsonCodec.above(LOCAL_DATE_TIME, min);
    }

    public static JsonCodec<LocalDateTime> localDateTimeUnder(LocalDateTime max) {
        return JsonCodec.under(LOCAL_DATE_TIME, max);
    }

    public static JsonCodec<LocalTime> localTime(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, LocalTime::from);
    }

    public static JsonCodec<LocalTime> localTimeIn(DateTimeFormatter formatter, LocalTime min, LocalTime max) {
        return JsonCodec.in(JsonCodec.localTime(formatter), min, max);
    }

    public static JsonCodec<LocalTime> localTimeAbove(DateTimeFormatter formatter, LocalTime min) {
        return JsonCodec.above(JsonCodec.localTime(formatter), min);
    }

    public static JsonCodec<LocalTime> localTimeUnder(DateTimeFormatter formatter, LocalTime max) {
        return JsonCodec.under(JsonCodec.localTime(formatter), max);
    }

    public static JsonCodec<LocalTime> localTimeIn(LocalTime min, LocalTime max) {
        return JsonCodec.in(LOCAL_TIME, min, max);
    }

    public static JsonCodec<LocalTime> localTimeAbove(LocalTime min) {
        return JsonCodec.above(LOCAL_TIME, min);
    }

    public static JsonCodec<LocalTime> localTimeUnder(LocalTime max) {
        return JsonCodec.under(LOCAL_TIME, max);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTime(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, OffsetDateTime::from);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeIn(DateTimeFormatter formatter, OffsetDateTime min, OffsetDateTime max) {
        return JsonCodec.in(JsonCodec.offsetDateTime(formatter), min, max);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeAbove(DateTimeFormatter formatter, OffsetDateTime min) {
        return JsonCodec.above(JsonCodec.offsetDateTime(formatter), min);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeUnder(DateTimeFormatter formatter, OffsetDateTime max) {
        return JsonCodec.under(JsonCodec.offsetDateTime(formatter), max);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeIn(OffsetDateTime min, OffsetDateTime max) {
        return JsonCodec.in(OFFSET_DATE_TIME, min, max);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeAbove(OffsetDateTime min) {
        return JsonCodec.above(OFFSET_DATE_TIME, min);
    }

    public static JsonCodec<OffsetDateTime> offsetDateTimeUnder(OffsetDateTime max) {
        return JsonCodec.under(OFFSET_DATE_TIME, max);
    }

    public static JsonCodec<OffsetTime> offsetTime(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, OffsetTime::from);
    }

    public static JsonCodec<OffsetTime> offsetTimeIn(DateTimeFormatter formatter, OffsetTime min, OffsetTime max) {
        return JsonCodec.in(JsonCodec.offsetTime(formatter), min, max);
    }

    public static JsonCodec<OffsetTime> offsetTimeAbove(DateTimeFormatter formatter, OffsetTime min) {
        return JsonCodec.above(JsonCodec.offsetTime(formatter), min);
    }

    public static JsonCodec<OffsetTime> offsetTimeUnder(DateTimeFormatter formatter, OffsetTime max) {
        return JsonCodec.under(JsonCodec.offsetTime(formatter), max);
    }

    public static JsonCodec<OffsetTime> offsetTimeIn(OffsetTime min, OffsetTime max) {
        return JsonCodec.in(OFFSET_TIME, min, max);
    }

    public static JsonCodec<OffsetTime> offsetTimeAbove(OffsetTime min) {
        return JsonCodec.above(OFFSET_TIME, min);
    }

    public static JsonCodec<OffsetTime> offsetTimeUnder(OffsetTime max) {
        return JsonCodec.under(OFFSET_TIME, max);
    }

    public static JsonCodec<Year> year(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, Year::from);
    }

    public static JsonCodec<Year> yearIn(DateTimeFormatter formatter, Year min, Year max) {
        return JsonCodec.in(JsonCodec.year(formatter), min, max);
    }

    public static JsonCodec<Year> yearAbove(DateTimeFormatter formatter, Year min) {
        return JsonCodec.above(JsonCodec.year(formatter), min);
    }

    public static JsonCodec<Year> yearUnder(DateTimeFormatter formatter, Year max) {
        return JsonCodec.under(JsonCodec.year(formatter), max);
    }

    public static JsonCodec<Year> yearIn(Year min, Year max) {
        return JsonCodec.in(YEAR, min, max);
    }

    public static JsonCodec<Year> yearAbove(Year min) {
        return JsonCodec.above(YEAR, min);
    }

    public static JsonCodec<Year> yearUnder(Year max) {
        return JsonCodec.under(YEAR, max);
    }

    public static JsonCodec<Month> month(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, Month::from);
    }

    public static JsonCodec<Month> monthIn(DateTimeFormatter formatter, Month min, Month max) {
        return JsonCodec.in(JsonCodec.month(formatter), min, max);
    }

    public static JsonCodec<Month> monthAbove(DateTimeFormatter formatter, Month min) {
        return JsonCodec.above(JsonCodec.month(formatter), min);
    }

    public static JsonCodec<Month> monthUnder(DateTimeFormatter formatter, Month max) {
        return JsonCodec.under(JsonCodec.month(formatter), max);
    }

    public static JsonCodec<Month> monthIn(Month min, Month max) {
        return JsonCodec.in(MONTH, min, max);
    }

    public static JsonCodec<Month> monthAbove(Month min) {
        return JsonCodec.above(MONTH, min);
    }

    public static JsonCodec<Month> monthUnder(Month max) {
        return JsonCodec.under(MONTH, max);
    }

    public static JsonCodec<YearMonth> yearMonth(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, YearMonth::from);
    }

    public static JsonCodec<YearMonth> yearMonthIn(DateTimeFormatter formatter, YearMonth min, YearMonth max) {
        return JsonCodec.in(JsonCodec.yearMonth(formatter), min, max);
    }

    public static JsonCodec<YearMonth> yearMonthAbove(DateTimeFormatter formatter, YearMonth min) {
        return JsonCodec.above(JsonCodec.yearMonth(formatter), min);
    }

    public static JsonCodec<YearMonth> yearMonthUnder(DateTimeFormatter formatter, YearMonth max) {
        return JsonCodec.under(JsonCodec.yearMonth(formatter), max);
    }

    public static JsonCodec<YearMonth> yearMonthIn(YearMonth min, YearMonth max) {
        return JsonCodec.in(YEAR_MONTH, min, max);
    }

    public static JsonCodec<YearMonth> yearMonthAbove(YearMonth min) {
        return JsonCodec.above(YEAR_MONTH, min);
    }

    public static JsonCodec<YearMonth> yearMonthUnder(YearMonth max) {
        return JsonCodec.under(YEAR_MONTH, max);
    }

    public static JsonCodec<MonthDay> monthDay(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, MonthDay::from);
    }

    public static JsonCodec<MonthDay> monthDayIn(DateTimeFormatter formatter, MonthDay min, MonthDay max) {
        return JsonCodec.in(JsonCodec.monthDay(formatter), min, max);
    }

    public static JsonCodec<MonthDay> monthDayAbove(DateTimeFormatter formatter, MonthDay min) {
        return JsonCodec.above(JsonCodec.monthDay(formatter), min);
    }

    public static JsonCodec<MonthDay> monthDayUnder(DateTimeFormatter formatter, MonthDay max) {
        return JsonCodec.under(JsonCodec.monthDay(formatter), max);
    }

    public static JsonCodec<MonthDay> monthDayIn(MonthDay min, MonthDay max) {
        return JsonCodec.in(MONTH_DAY, min, max);
    }

    public static JsonCodec<MonthDay> monthDayAbove(MonthDay min) {
        return JsonCodec.above(MONTH_DAY, min);
    }

    public static JsonCodec<MonthDay> monthDayUnder(MonthDay max) {
        return JsonCodec.under(MONTH_DAY, max);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTime(DateTimeFormatter formatter) {
        return JsonCodec.temporal(formatter, ZonedDateTime::from);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeIn(DateTimeFormatter formatter, ZonedDateTime min, ZonedDateTime max) {
        return JsonCodec.in(JsonCodec.zonedDateTime(formatter), min, max);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeAbove(DateTimeFormatter formatter, ZonedDateTime min) {
        return JsonCodec.above(JsonCodec.zonedDateTime(formatter), min);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeUnder(DateTimeFormatter formatter, ZonedDateTime max) {
        return JsonCodec.under(JsonCodec.zonedDateTime(formatter), max);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeIn(ZonedDateTime min, ZonedDateTime max) {
        return JsonCodec.in(ZONED_DATE_TIME, min, max);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeAbove(ZonedDateTime min) {
        return JsonCodec.above(ZONED_DATE_TIME, min);
    }

    public static JsonCodec<ZonedDateTime> zonedDateTimeUnder(ZonedDateTime max) {
        return JsonCodec.under(ZONED_DATE_TIME, max);
    }
}

