/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl;

import dev.runefox.json.NodeType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Internal {
    public static final NodeType[][] EXCLUDING_ARRAYS = new NodeType[][]{{NodeType.NUMBER, NodeType.BOOLEAN, NodeType.NULL, NodeType.ARRAY, NodeType.OBJECT}, {NodeType.STRING, NodeType.BOOLEAN, NodeType.NULL, NodeType.ARRAY, NodeType.OBJECT}, {NodeType.STRING, NodeType.NUMBER, NodeType.NULL, NodeType.ARRAY, NodeType.OBJECT}, {NodeType.STRING, NodeType.NUMBER, NodeType.BOOLEAN, NodeType.ARRAY, NodeType.OBJECT}, {NodeType.STRING, NodeType.NUMBER, NodeType.BOOLEAN, NodeType.NULL, NodeType.OBJECT}, {NodeType.STRING, NodeType.NUMBER, NodeType.BOOLEAN, NodeType.NULL, NodeType.ARRAY}};
    public static final NodeType[] PRIMITIVES = new NodeType[]{NodeType.STRING, NodeType.NUMBER, NodeType.BOOLEAN};
    public static final NodeType[] CONSTRUCTS = new NodeType[]{NodeType.ARRAY, NodeType.OBJECT};
    public static final NodeType[] NOT_PRIMITIVES = new NodeType[]{NodeType.NULL, NodeType.ARRAY, NodeType.OBJECT};
    public static final NodeType[] NOT_CONSTRUCTS = new NodeType[]{NodeType.STRING, NodeType.NUMBER, NodeType.BOOLEAN, NodeType.NULL};
    public static final NodeType[] WITH_LENGTH = new NodeType[]{NodeType.STRING, NodeType.ARRAY, NodeType.OBJECT};
    public static final NodeType[] VALUES = NodeType.values();

    public static NodeType[] allExcluding(NodeType type) {
        if (type == null) {
            return NodeType.values();
        }
        return (NodeType[])EXCLUDING_ARRAYS[type.ordinal()].clone();
    }

    public static NodeType[] primitives() {
        return (NodeType[])PRIMITIVES.clone();
    }

    public static NodeType[] constructs() {
        return (NodeType[])CONSTRUCTS.clone();
    }

    public static NodeType[] notPrimitives() {
        return (NodeType[])NOT_PRIMITIVES.clone();
    }

    public static NodeType[] notConstructs() {
        return (NodeType[])NOT_CONSTRUCTS.clone();
    }

    public static NodeType[] allExcluding0(NodeType type) {
        if (type == null) {
            return VALUES;
        }
        return (NodeType[])EXCLUDING_ARRAYS[type.ordinal()].clone();
    }

    public static String makeMessageInv(NodeType found, NodeType ... prohibited) {
        HashSet<NodeType> types = new HashSet<NodeType>(Arrays.asList(prohibited));
        Object[] objectArray = new Object[2];
        objectArray[0] = Stream.of(VALUES).filter(types::contains).map(Enum::name).collect(Collectors.joining(", "));
        objectArray[1] = found;
        return String.format("Unmatched types, required %s, found %s", objectArray);
    }
}

