/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.node;

import dev.runefox.json.IncorrectTypeException;
import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeType;
import dev.runefox.json.impl.node.AbstractPrimitiveNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class StringNode
extends AbstractPrimitiveNode {
    private final String string;

    public StringNode(String string) {
        super(NodeType.STRING);
        this.string = string;
    }

    @Override
    public JsonNode ifString(BiConsumer<JsonNode, String> action) {
        action.accept(this, this.string);
        return this;
    }

    @Override
    public String asExactString() {
        return this.string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public byte asByte() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public short asShort() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public int asInt() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public long asLong() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public float asFloat() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public double asDouble() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public BigInteger asBigInteger() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public Number asNumber() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.NUMBER);
    }

    @Override
    public boolean asBoolean() {
        throw new IncorrectTypeException(NodeType.STRING, NodeType.BOOLEAN);
    }

    @Override
    public int length() {
        return this.string.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringNode other = (StringNode)o;
        return this.string.equals(other.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return StringNode.quote(this.string);
    }

    public static void quote(String string, StringBuilder builder, char quote) {
        builder.append(quote);
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            char c = string.charAt(i);
            if (c == quote || c == '\\') {
                builder.append("\\");
            }
            if (c < ' ' || c > '\u007f') {
                if (c == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    builder.append("\\r");
                    continue;
                }
                if (c == '\t') {
                    builder.append("\\t");
                    continue;
                }
                builder.append(String.format("\\u%04X", c));
                continue;
            }
            builder.append(c);
        }
        builder.append(quote);
    }

    static String quote(String string) {
        StringBuilder builder = new StringBuilder();
        StringNode.quote(string, builder, '\"');
        return builder.toString();
    }
}

