/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.parse;

import dev.runefox.json.SyntaxException;
import dev.runefox.json.impl.parse.Token;
import dev.runefox.json.impl.parse.json.JsonTokenType;
import java.io.IOException;
import java.io.Reader;
import java.nio.BufferUnderflowException;

public abstract class AbstractLexer {
    private static final int READ_BUFFER_SIZE = 4096;
    private final Reader reader;
    private int[] buffer = new int[128];
    private int bufferPos = 0;
    private int lastPos;
    private int lastLine = 1;
    private int lastCol = 1;
    private int startPos;
    private int startLine = 1;
    private int startCol = 1;
    private int pos;
    private int line = 1;
    private int col = 1;
    protected int c;
    protected LexerState state;
    private boolean canSeeCrlf;
    private boolean retain;
    private final char[] readBuffer = new char[4097];
    private int readBufferSize = 0;
    private int readBufferPos = 0;
    private Token reuseToken;
    private int remember;

    public AbstractLexer(Reader reader) {
        this.reader = reader;
    }

    public int pos() {
        return this.pos;
    }

    public int line() {
        return this.line;
    }

    public int col() {
        return this.col;
    }

    public void skipNonExecutePrefixes() throws IOException {
        int l;
        int r;
        int len = ")]}'\n".length();
        char[] buf = new char[len];
        for (l = 0; l < len && (r = this.reader.read(buf, l, len - l)) >= 0; l += r) {
        }
        String prefix = new String(buf, 0, l);
        if (prefix.equals(")]}'\n") || prefix.equals(")]}'\r")) {
            return;
        }
        System.arraycopy(buf, 0, this.readBuffer, 0, l);
        this.readBufferSize = l;
    }

    private void extendBuffer() {
        int[] oldbuf = this.buffer;
        int oldlen = oldbuf.length;
        int[] newbuf = new int[oldlen + 128];
        System.arraycopy(oldbuf, 0, newbuf, 0, oldlen);
        this.buffer = newbuf;
    }

    public LexerState state() {
        return this.state;
    }

    public void state(LexerState state) {
        this.state = state;
    }

    public void remember(int c) {
        this.remember = c;
    }

    public int remembered() {
        return this.remember;
    }

    public String buffered() {
        return new String(this.buffer, 0, this.bufferPos);
    }

    public void store(int c) {
        if (this.bufferPos >= this.buffer.length) {
            this.extendBuffer();
        }
        this.buffer[this.bufferPos] = c;
        ++this.bufferPos;
    }

    public int unstore() {
        if (this.bufferPos == 0) {
            throw new BufferUnderflowException();
        }
        return this.buffer[--this.bufferPos];
    }

    public void clear() {
        this.bufferPos = 0;
    }

    public void startToken() {
        this.startPos = this.lastPos;
        this.startLine = this.lastLine;
        this.startCol = this.lastCol;
    }

    public Token newToken(JsonTokenType type, Object val) {
        Token reuse = this.reuseToken;
        if (reuse != null) {
            this.reuseToken = null;
            reuse.set(type, val, this.startPos, this.startLine, this.startCol, this.pos, this.line, this.col);
            return reuse;
        }
        return new Token(type, val, this.startPos, this.startLine, this.startCol, this.pos, this.line, this.col);
    }

    protected abstract LexerState defaultState();

    private int readBuffered() throws IOException {
        char hi;
        char lo;
        if (this.readBufferSize < 0) {
            return -1;
        }
        if (this.readBufferPos >= this.readBufferSize) {
            this.readBufferPos = 0;
            int size = this.reader.read(this.readBuffer, 0, 4096);
            if (size < 0) {
                this.readBufferSize = -1;
                return -1;
            }
            if (Character.isHighSurrogate(this.readBuffer[size - 1]) && (lo = this.reader.read()) >= '\u0000') {
                this.readBuffer[size] = lo;
                ++size;
            }
            this.readBufferSize = size;
        }
        if (Character.isHighSurrogate(hi = this.readBuffer[this.readBufferPos++])) {
            lo = this.readBuffer[this.readBufferPos++];
            return Character.toCodePoint(hi, lo);
        }
        return hi;
    }

    private int readIncrPos() throws IOException {
        int c = this.readBuffered();
        ++this.pos;
        return c;
    }

    private int read() throws IOException {
        int c = this.readIncrPos();
        if (this.canSeeCrlf && c == 10) {
            c = this.readIncrPos();
        }
        this.canSeeCrlf = false;
        if (c == 13) {
            this.canSeeCrlf = true;
            c = 10;
        }
        if (c == 10) {
            ++this.line;
            this.col = 1;
        } else {
            ++this.col;
        }
        return c;
    }

    public void retain() {
        this.retain = true;
    }

    public Token token(Token reuse) throws IOException {
        Token token;
        this.state = this.defaultState();
        this.reuseToken = reuse;
        do {
            this.lastPos = this.pos;
            this.lastLine = this.line;
            this.lastCol = this.col;
            if (!this.retain) {
                this.c = this.read();
            }
            this.retain = false;
        } while ((token = this.state().lex(this.c, this)) == null);
        return token;
    }

    public SyntaxException error(String problem) {
        return new SyntaxException(this.startPos, this.startLine, this.startCol, this.pos, this.line, this.col, problem);
    }

    public SyntaxException localError(String problem) {
        return new SyntaxException(this.lastPos, this.lastLine, this.lastCol, this.pos, this.line, this.col, problem);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    @FunctionalInterface
    public static interface LexerState {
        public Token lex(int var1, AbstractLexer var2) throws SyntaxException;
    }
}

