/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.parse.json;

import dev.runefox.json.SyntaxException;
import dev.runefox.json.impl.UnparsedHexNumber;
import dev.runefox.json.impl.UnparsedNumber;
import dev.runefox.json.impl.parse.AbstractLexer;
import dev.runefox.json.impl.parse.CharUtil;
import dev.runefox.json.impl.parse.Token;
import dev.runefox.json.impl.parse.json.JsonTokenType;
import java.io.Reader;

public class Json5Lexer
extends AbstractLexer {
    public Json5Lexer(Reader reader) {
        super(reader);
    }

    @Override
    protected AbstractLexer.LexerState defaultState() {
        return JsonLexerState.DEFAULT;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum JsonLexerState implements AbstractLexer.LexerState
    {
        DEFAULT{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isEof(c)) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.EOF, null);
                }
                if (CharUtil.isWhitespace5(c)) {
                    return null;
                }
                if (c == 123) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.OBJECT_START, null);
                }
                if (c == 125) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.OBJECT_END, null);
                }
                if (c == 91) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.ARRAY_START, null);
                }
                if (c == 93) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.ARRAY_END, null);
                }
                if (c == 58) {
                    lex.startToken();
                    return lex.newToken(JsonTokenType.COLON, null);
                }
                if (c == 44) {
                    lex.startToken();
                    lex.state(COMMA);
                    return null;
                }
                if (c == 34 || c == 39) {
                    lex.clear();
                    lex.state(STRING);
                    lex.remember(c);
                    lex.startToken();
                    return null;
                }
                if (c == 47) {
                    lex.state(COMMENT_START);
                    lex.startToken();
                    return null;
                }
                if (CharUtil.isDigit(c) || c == 46) {
                    lex.clear();
                    lex.retain();
                    lex.state(NUMBER_START);
                    lex.startToken();
                    return null;
                }
                if (c == 45 || c == 43) {
                    lex.clear();
                    lex.store(c);
                    lex.state(NUMBER_SIGN);
                    lex.startToken();
                    return null;
                }
                if (c == 101 || c == 69) {
                    lex.clear();
                    lex.store(c);
                    lex.state(E_IDENTIFIER);
                    lex.startToken();
                    return null;
                }
                if (c == 92) {
                    lex.clear();
                    lex.state(START_IDENTIFIER_ESCAPE);
                    lex.startToken();
                    return null;
                }
                if (CharUtil.isIdentifierStart(c)) {
                    lex.clear();
                    lex.store(c);
                    lex.state(IDENTIFIER);
                    lex.startToken();
                    return null;
                }
                lex.startToken();
                throw lex.localError("Illegal character");
            }
        }
        ,
        COMMA{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isWhitespace5(c)) {
                    return null;
                }
                if (c == 93) {
                    return lex.newToken(JsonTokenType.ARRAY_END, null);
                }
                if (c == 125) {
                    return lex.newToken(JsonTokenType.OBJECT_END, null);
                }
                lex.retain();
                lex.state(DEFAULT);
                return lex.newToken(JsonTokenType.COMMA, null);
            }
        }
        ,
        STRING{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isNewline5(c) || CharUtil.isEof(c)) {
                    throw lex.localError("Expected string end");
                }
                if (c == 92) {
                    lex.state(STRING_ESCAPE);
                } else {
                    if (c == lex.remembered()) {
                        lex.state(DEFAULT);
                        return lex.newToken(JsonTokenType.STRING, lex.buffered());
                    }
                    lex.store(c);
                }
                return null;
            }
        }
        ,
        STRING_ESCAPE{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isEof(c)) {
                    throw lex.localError("Expected string escape");
                }
                if (!CharUtil.isNewline5(c)) {
                    if (c == 110) {
                        lex.store(10);
                    } else if (c == 98) {
                        lex.store(8);
                    } else if (c == 114) {
                        lex.store(13);
                    } else if (c == 102) {
                        lex.store(12);
                    } else if (c == 116) {
                        lex.store(9);
                    } else if (c == 48) {
                        lex.store(0);
                    } else {
                        if (c == 117) {
                            lex.store(0);
                            lex.state(UNICODE_ESCAPE_1);
                            return null;
                        }
                        if (c == 120) {
                            lex.store(0);
                            lex.state(HEX_ESCAPE_1);
                            return null;
                        }
                        if (!CharUtil.isDigit1to9(c)) {
                            lex.store(c);
                        } else {
                            throw lex.localError("Illegal escape sequence");
                        }
                    }
                }
                lex.state(STRING);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_1{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 4 more hex digits");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex << 12));
                lex.state(UNICODE_ESCAPE_2);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_2{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 3 more hex digits");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex << 8));
                lex.state(UNICODE_ESCAPE_3);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_3{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 2 more hex digits");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex << 4));
                lex.state(UNICODE_ESCAPE_4);
                return null;
            }
        }
        ,
        UNICODE_ESCAPE_4{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 1 more hex digit");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex));
                if (lex.remembered() == 2) {
                    lex.state(IDENTIFIER_ESCAPE_END);
                } else if (lex.remembered() == 1) {
                    lex.state(START_IDENTIFIER_ESCAPE_END);
                } else {
                    lex.state(STRING);
                }
                return null;
            }
        }
        ,
        HEX_ESCAPE_1{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 2 more hex digits");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex << 4));
                lex.state(HEX_ESCAPE_2);
                return null;
            }
        }
        ,
        HEX_ESCAPE_2{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int hex = CharUtil.getHexDigitValue(c);
                if (hex < 0) {
                    throw lex.localError("Expected 1 more hex digit");
                }
                int s = lex.unstore();
                lex.store((char)(s |= hex));
                lex.state(STRING);
                return null;
            }
        }
        ,
        E_IDENTIFIER{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                    return null;
                }
                if (CharUtil.isIdentifier(c)) {
                    lex.store(c);
                    lex.state(IDENTIFIER);
                    return null;
                }
                if (c == 92) {
                    lex.state(IDENTIFIER_ESCAPE);
                    return null;
                }
                lex.state(DEFAULT);
                lex.retain();
                return lex.newToken(JsonTokenType.NUMBER, new UnparsedNumber(lex.buffered()));
            }
        }
        ,
        IDENTIFIER{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                String kw;
                if (CharUtil.isIdentifier(c)) {
                    lex.store(c);
                    return null;
                }
                if (c == 92) {
                    lex.state(IDENTIFIER_ESCAPE);
                    return null;
                }
                lex.state(DEFAULT);
                lex.retain();
                switch (kw = lex.buffered()) {
                    case "false": {
                        return lex.newToken(JsonTokenType.BOOLEAN, false);
                    }
                    case "true": {
                        return lex.newToken(JsonTokenType.BOOLEAN, true);
                    }
                    case "null": {
                        return lex.newToken(JsonTokenType.NULL, null);
                    }
                    case "NaN": {
                        return lex.newToken(JsonTokenType.NUMBER, Double.NaN);
                    }
                    case "Infinity": {
                        return lex.newToken(JsonTokenType.NUMBER, Double.POSITIVE_INFINITY);
                    }
                }
                return lex.newToken(JsonTokenType.IDENTIFIER, kw);
            }
        }
        ,
        IDENTIFIER_ESCAPE{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (c != 117) {
                    throw lex.localError("Illegal identifier escape");
                }
                lex.remember(2);
                lex.store(0);
                lex.state(UNICODE_ESCAPE_1);
                return null;
            }
        }
        ,
        IDENTIFIER_ESCAPE_END{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int s = lex.unstore();
                if (!CharUtil.isIdentifier(s)) {
                    throw lex.localError("Invalid identifier escape sequence");
                }
                lex.store(s);
                lex.state(IDENTIFIER);
                lex.retain();
                return null;
            }
        }
        ,
        START_IDENTIFIER_ESCAPE{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (c != 117) {
                    throw lex.localError("Illegal identifier escape");
                }
                lex.remember(1);
                lex.store(0);
                lex.state(UNICODE_ESCAPE_1);
                return null;
            }
        }
        ,
        START_IDENTIFIER_ESCAPE_END{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                int s = lex.unstore();
                if (!CharUtil.isIdentifierStart(s)) {
                    throw lex.localError("Invalid identifier start escape sequence");
                }
                lex.store(s);
                lex.state(IDENTIFIER);
                lex.retain();
                return null;
            }
        }
        ,
        NUMBER_SIGN{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c) || c == 46 || c == 101 || c == 69) {
                    lex.state(NUMBER_START);
                    lex.retain();
                    return null;
                }
                if (CharUtil.isIdentifierStart(c)) {
                    lex.state(SIGNED_INFINITY_NAN);
                    lex.retain();
                    return null;
                }
                lex.state(DEFAULT);
                lex.retain();
                return lex.newToken(JsonTokenType.NUMBER, new UnparsedNumber(lex.buffered()));
            }
        }
        ,
        SIGNED_INFINITY_NAN{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isIdentifier(c)) {
                    lex.store(c);
                    return null;
                }
                lex.state(DEFAULT);
                lex.retain();
                String kw = lex.buffered();
                if ("-Infinity".equals(kw)) {
                    return lex.newToken(JsonTokenType.NUMBER, Double.NEGATIVE_INFINITY);
                }
                if ("+Infinity".equals(kw)) {
                    return lex.newToken(JsonTokenType.NUMBER, Double.POSITIVE_INFINITY);
                }
                if ("-NaN".equals(kw) || "+NaN".equals(kw)) {
                    return lex.newToken(JsonTokenType.NUMBER, Double.NaN);
                }
                throw lex.error("Illegal number");
            }
        }
        ,
        NUMBER_START{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (c == 48) {
                    lex.store(c);
                    lex.state(ZERO);
                } else if (CharUtil.isDigit(c)) {
                    lex.store(c);
                    lex.state(NUMBER_INTEGER);
                } else if (c == 46) {
                    lex.retain();
                    lex.state(NUMBER_DECIMAL_START);
                } else if (c == 101 || c == 69) {
                    lex.retain();
                    lex.state(NUMBER_EXPONENT_START);
                } else {
                    throw lex.localError("Expected number");
                }
                return null;
            }
        }
        ,
        ZERO{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                    lex.state(NUMBER_INTEGER);
                } else if (c == 120 || c == 88) {
                    lex.store(c);
                    lex.state(NUMBER_HEXADECIMAL);
                } else {
                    lex.retain();
                    lex.state(NUMBER_DECIMAL_START);
                }
                return null;
            }
        }
        ,
        NUMBER_HEXADECIMAL{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (!CharUtil.isHexDigit(c)) {
                    lex.retain();
                    lex.state(DEFAULT);
                    String nr = lex.buffered();
                    return lex.newToken(JsonTokenType.NUMBER, new UnparsedHexNumber(nr));
                }
                lex.store(c);
                return null;
            }
        }
        ,
        NUMBER_INTEGER{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_DECIMAL_START);
                }
                return null;
            }
        }
        ,
        NUMBER_DECIMAL_START{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (c == 46) {
                    lex.store(c);
                    lex.state(NUMBER_DECIMAL);
                } else {
                    lex.retain();
                    lex.state(NUMBER_EXPONENT_START);
                }
                return null;
            }
        }
        ,
        NUMBER_DECIMAL{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_EXPONENT_START);
                }
                return null;
            }
        }
        ,
        NUMBER_EXPONENT_START{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (c == 101 || c == 69) {
                    lex.store(c);
                    lex.state(NUMBER_EXPONENT_SIGN);
                } else {
                    lex.retain();
                    lex.state(NUMBER_END);
                }
                return null;
            }
        }
        ,
        NUMBER_EXPONENT_SIGN{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (c == 45 || c == 43) {
                    lex.store(c);
                } else {
                    lex.retain();
                }
                lex.state(NUMBER_EXPONENT);
                return null;
            }
        }
        ,
        NUMBER_EXPONENT{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isDigit(c)) {
                    lex.store(c);
                } else {
                    lex.retain();
                    lex.state(NUMBER_END);
                }
                return null;
            }
        }
        ,
        NUMBER_END{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                lex.retain();
                String nr = lex.buffered();
                return lex.newToken(JsonTokenType.NUMBER, new UnparsedNumber(nr));
            }
        }
        ,
        COMMENT_START{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (c == 47) {
                    lex.state(LINE_COMMENT);
                } else if (c == 42) {
                    lex.state(BLOCK_COMMENT);
                } else {
                    throw lex.error("Illegal '/'");
                }
                return null;
            }
        }
        ,
        LINE_COMMENT{

            @Override
            public Token lex(int c, AbstractLexer lex) {
                if (CharUtil.isNewline5(c) || CharUtil.isEof(c)) {
                    lex.state(DEFAULT);
                }
                return null;
            }
        }
        ,
        BLOCK_COMMENT{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isEof(c)) {
                    throw lex.localError("Unfinished block comment");
                }
                if (c == 42) {
                    lex.state(BLOCK_COMMENT_END);
                }
                return null;
            }
        }
        ,
        BLOCK_COMMENT_END{

            @Override
            public Token lex(int c, AbstractLexer lex) throws SyntaxException {
                if (CharUtil.isEof(c)) {
                    throw lex.localError("Unfinished block comment");
                }
                if (c == 47) {
                    lex.state(DEFAULT);
                }
                return null;
            }
        };

    }
}

