/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;

class ComparableUnderCodec<A extends Comparable<? super A>>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A max;

    ComparableUnderCodec(JsonCodec<A> codec, A max) {
        this.codec = codec;
        this.max = max;
    }

    private A check(A a) {
        if (a.compareTo(this.max) > 0) {
            throw new CodecException("Value " + a + " above limit " + this.max);
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return (A)this.check((Comparable)this.codec.decode(json));
    }
}

