/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import java.util.Comparator;

class ComparatorAboveCodec<A>
implements JsonCodec<A> {
    private final JsonCodec<A> codec;
    private final A min;
    private final Comparator<? super A> comp;

    ComparatorAboveCodec(JsonCodec<A> codec, A min, Comparator<? super A> comp) {
        this.codec = codec;
        this.min = min;
        this.comp = comp;
    }

    private A check(A a) {
        if (this.comp.compare(a, this.min) < 0) {
            throw new CodecException("Value " + a + " under minimum " + this.min);
        }
        return a;
    }

    @Override
    public JsonNode encode(A obj) {
        return this.codec.encode(this.check(obj));
    }

    @Override
    public A decode(JsonNode json) {
        return this.check(this.codec.decode(json));
    }
}

