/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.JsonCodec;
import dev.runefox.json.codec.JsonEncodable;
import java.util.function.Function;

class EncodableCodec<A extends JsonEncodable>
implements JsonCodec<A> {
    private final Function<JsonNode, A> instanceFactory;

    EncodableCodec(Function<JsonNode, A> instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    @Override
    public JsonNode encode(A obj) {
        return obj.toJson();
    }

    @Override
    public A decode(JsonNode json) {
        JsonEncodable obj = (JsonEncodable)this.instanceFactory.apply(json);
        obj.fromJson(json);
        return (A)obj;
    }
}

