/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import java.util.List;
import java.util.stream.Collectors;

class ListCodec<A>
implements JsonCodec<List<A>> {
    private final JsonCodec<A> elementCodec;
    private final int minL;
    private final int maxL;

    ListCodec(JsonCodec<A> elementCodec) {
        this.elementCodec = elementCodec;
        this.minL = 0;
        this.maxL = Integer.MAX_VALUE;
    }

    ListCodec(JsonCodec<A> elementCodec, int maxL) {
        this.elementCodec = elementCodec;
        if (maxL < 0) {
            throw new IllegalArgumentException("max < min");
        }
        this.minL = 0;
        this.maxL = maxL;
    }

    ListCodec(JsonCodec<A> elementCodec, int minL, int maxL) {
        this.elementCodec = elementCodec;
        minL = Math.max(0, minL);
        if (maxL < minL) {
            throw new IllegalArgumentException("max < min");
        }
        this.minL = minL;
        this.maxL = maxL;
    }

    private void checkLength(int l) {
        if (l < this.minL || l > this.maxL) {
            throw new CodecException("Length of list out of expected range [" + this.minL + ".." + this.maxL + "]");
        }
    }

    @Override
    public JsonNode encode(List<A> obj) {
        this.checkLength(obj.size());
        return obj.stream().map(this.elementCodec::encode).collect(JsonNode.arrayCollector());
    }

    @Override
    public List<A> decode(JsonNode json) {
        this.checkLength(json.requireArray().size());
        return json.stream().map(this.elementCodec::decode).collect(Collectors.toList());
    }
}

