/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.codec;

import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeException;
import dev.runefox.json.codec.CodecException;
import dev.runefox.json.codec.JsonCodec;
import dev.runefox.json.codec.JsonEncodable;
import dev.runefox.json.codec.JsonRepresentable;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class RecordCodec<A>
implements JsonCodec<A> {
    private final ThreadLocal<ContextStack<DecodeContextImpl<A>>> decodeStack = ThreadLocal.withInitial(() -> new ContextStack<DecodeContextImpl>(DecodeContextImpl::new));
    private final ThreadLocal<ContextStack<EncodeContextImpl<A>>> encodeStack = ThreadLocal.withInitial(() -> new ContextStack<EncodeContextImpl>(EncodeContextImpl::new));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public A decode(JsonNode json) {
        json.requireObject();
        ContextStack<DecodeContextImpl<A>> stack = this.decodeStack.get();
        try {
            DecodeContextImpl<A> context = stack.push();
            context.json(json);
            A a = this.decode(context);
            return a;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonNode encode(A obj) {
        ContextStack<EncodeContextImpl<A>> stack = this.encodeStack.get();
        try {
            EncodeContextImpl<A> context = stack.push();
            context.newJson();
            this.encode(context, obj);
            JsonNode jsonNode = context.json;
            return jsonNode;
        }
        finally {
            stack.pop();
        }
    }

    protected abstract A decode(DecodeContext<A> var1);

    protected abstract void encode(EncodeContext<A> var1, A var2);

    private static class ContextStack<C> {
        private final List<C> stack = new ArrayList<C>();
        private final Supplier<C> factory;
        private int pointer;

        private ContextStack(Supplier<C> factory) {
            this.factory = factory;
            this.stack.add(factory.get());
        }

        public C push() {
            if (this.pointer == this.stack.size()) {
                this.stack.add(this.factory.get());
            }
            return this.stack.get(this.pointer++);
        }

        public void pop() {
            if (this.pointer == 0) {
                throw new EmptyStackException();
            }
            --this.pointer;
        }
    }

    private static class DecodeContextImpl<I>
    implements DecodeContext<I> {
        private JsonNode json;

        private DecodeContextImpl() {
        }

        void json(JsonNode json) {
            this.json = json;
        }

        @Override
        public JsonNode json() {
            return this.json;
        }

        @Override
        public boolean has(String key) {
            return this.json.has(key);
        }

        @Override
        public JsonNode field(String key) {
            if (!this.json.has(key)) {
                throw new CodecException("Expected key '" + key + "'");
            }
            return this.json.get(key);
        }

        @Override
        public JsonNode optionalField(String key) {
            return this.json.get(key);
        }

        @Override
        public void applyField(String key, Consumer<? super JsonNode> applier) {
            if (this.json.has(key)) {
                applier.accept(this.json.get(key));
            }
        }

        private static <A> A decode(JsonCodec<A> codec, JsonNode node, String key) {
            try {
                return codec.decode(node);
            }
            catch (NodeException exc) {
                throw new CodecException(key + " > " + exc.getMessage(), exc);
            }
        }

        @Override
        public <A> A field(String key, JsonCodec<A> codec) {
            return DecodeContextImpl.decode(codec, this.field(key), key);
        }

        @Override
        public <A> A optionalField(String key, JsonCodec<A> codec) {
            JsonNode node = this.optionalField(key);
            return node == null ? null : (A)DecodeContextImpl.decode(codec, node, key);
        }

        @Override
        public <A> void applyField(String key, JsonCodec<A> codec, Consumer<? super A> applier) {
            this.applyField(key, json -> applier.accept((Object)DecodeContextImpl.decode(codec, json, key)));
        }

        private static <A extends JsonEncodable> A decode(Function<JsonNode, A> factory, JsonNode node, String key) {
            try {
                JsonEncodable obj = (JsonEncodable)factory.apply(node);
                obj.fromJson(node);
                return (A)obj;
            }
            catch (NodeException exc) {
                throw new CodecException(key + " > " + exc.getMessage(), exc);
            }
        }

        @Override
        public <A extends JsonEncodable> A field(String key, Function<JsonNode, A> factory) {
            return DecodeContextImpl.decode(factory, this.field(key), key);
        }

        @Override
        public <A extends JsonEncodable> A optionalField(String key, Function<JsonNode, A> factory) {
            JsonNode node = this.optionalField(key);
            return node == null ? null : (A)DecodeContextImpl.decode(factory, node, key);
        }

        @Override
        public <A extends JsonEncodable> void applyField(String key, Function<JsonNode, A> factory, Consumer<? super A> applier) {
            this.applyField(key, node -> applier.accept((Object)DecodeContextImpl.decode(factory, node, key)));
        }

        @Override
        public <A extends JsonEncodable> A field(String key, Supplier<A> factory) {
            return (A)this.field(key, (JsonNode node) -> (JsonEncodable)factory.get());
        }

        @Override
        public <A extends JsonEncodable> A optionalField(String key, Supplier<A> factory) {
            return (A)this.optionalField(key, (JsonNode node) -> (JsonEncodable)factory.get());
        }

        @Override
        public <A extends JsonEncodable> void applyField(String key, Supplier<A> factory, Consumer<? super A> applier) {
            this.applyField(key, (JsonNode node) -> (JsonEncodable)factory.get(), applier);
        }
    }

    public static interface DecodeContext<I> {
        public JsonNode json();

        public boolean has(String var1);

        public JsonNode field(String var1);

        public JsonNode optionalField(String var1);

        public void applyField(String var1, Consumer<? super JsonNode> var2);

        public <A> A field(String var1, JsonCodec<A> var2);

        public <A> A optionalField(String var1, JsonCodec<A> var2);

        public <A> void applyField(String var1, JsonCodec<A> var2, Consumer<? super A> var3);

        public <A extends JsonEncodable> A field(String var1, Function<JsonNode, A> var2);

        public <A extends JsonEncodable> A optionalField(String var1, Function<JsonNode, A> var2);

        public <A extends JsonEncodable> void applyField(String var1, Function<JsonNode, A> var2, Consumer<? super A> var3);

        public <A extends JsonEncodable> A field(String var1, Supplier<A> var2);

        public <A extends JsonEncodable> A optionalField(String var1, Supplier<A> var2);

        public <A extends JsonEncodable> void applyField(String var1, Supplier<A> var2, Consumer<? super A> var3);
    }

    private static class EncodeContextImpl<I>
    implements EncodeContext<I> {
        private JsonNode json;

        private EncodeContextImpl() {
        }

        void newJson() {
            this.json = JsonNode.object();
        }

        @Override
        public JsonNode json() {
            return this.json;
        }

        private static <A extends JsonRepresentable> JsonNode encode(A obj, String key) {
            try {
                return obj.toJson();
            }
            catch (NodeException exc) {
                throw new CodecException(key + " > " + exc.getMessage(), exc);
            }
        }

        @Override
        public void field(String key, JsonRepresentable value) {
            this.json.set(key, value.toJson());
        }

        @Override
        public void supplyField(String key, Supplier<? extends JsonRepresentable> value) {
            this.field(key, EncodeContextImpl.encode(value.get(), key));
        }

        @Override
        public final void arrayField(String key, JsonRepresentable ... value) {
            this.arrayField(key, Stream.of(value));
        }

        @Override
        public void arrayField(String key, Stream<? extends JsonRepresentable> value) {
            this.field(key, value.map(a -> EncodeContextImpl.encode(a, key)).collect(JsonNode.arrayCollector()));
        }

        @Override
        public void supplyArrayField(String key, Supplier<Stream<? extends JsonRepresentable>> value) {
            this.arrayField(key, value.get());
        }

        private static <A> JsonNode encode(JsonCodec<A> codec, A obj, String key) {
            try {
                return codec.encode(obj);
            }
            catch (NodeException exc) {
                throw new CodecException(key + " > " + exc.getMessage(), exc);
            }
        }

        @Override
        public <A> void field(String key, JsonCodec<A> codec, A value) {
            this.field(key, EncodeContextImpl.encode(codec, value, key));
        }

        @Override
        public <A> void supplyField(String key, JsonCodec<A> codec, Supplier<? extends A> value) {
            this.field(key, EncodeContextImpl.encode(codec, value.get(), key));
        }

        @Override
        @SafeVarargs
        public final <A> void arrayField(String key, JsonCodec<A> codec, A ... value) {
            this.arrayField(key, codec, Stream.of(value));
        }

        @Override
        public <A> void arrayField(String key, JsonCodec<A> codec, Stream<A> value) {
            this.field(key, value.map(a -> EncodeContextImpl.encode(codec, a, key)).collect(JsonNode.arrayCollector()));
        }

        @Override
        public <A> void supplyArrayField(String key, JsonCodec<A> codec, Supplier<Stream<A>> value) {
            this.arrayField(key, codec, value.get());
        }
    }

    public static interface EncodeContext<I> {
        public JsonNode json();

        public void field(String var1, JsonRepresentable var2);

        public void supplyField(String var1, Supplier<? extends JsonRepresentable> var2);

        public void arrayField(String var1, JsonRepresentable ... var2);

        public void arrayField(String var1, Stream<? extends JsonRepresentable> var2);

        public void supplyArrayField(String var1, Supplier<Stream<? extends JsonRepresentable>> var2);

        public <A> void field(String var1, JsonCodec<A> var2, A var3);

        public <A> void supplyField(String var1, JsonCodec<A> var2, Supplier<? extends A> var3);

        public <A> void arrayField(String var1, JsonCodec<A> var2, A ... var3);

        public <A> void arrayField(String var1, JsonCodec<A> var2, Stream<A> var3);

        public <A> void supplyArrayField(String var1, JsonCodec<A> var2, Supplier<Stream<A>> var3);
    }
}

