/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl;

import dev.runefox.json.JsonNode;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class JsonArrayCollector<T>
implements Collector<T, JsonNode, JsonNode> {
    private final Function<? super T, JsonNode> serializer;
    private static final Set<Collector.Characteristics> CHARACTERISTICS = Set.of(Collector.Characteristics.IDENTITY_FINISH);

    public JsonArrayCollector(Function<? super T, JsonNode> serializer) {
        this.serializer = serializer;
    }

    @Override
    public Supplier<JsonNode> supplier() {
        return JsonNode::array;
    }

    @Override
    public BiConsumer<JsonNode, T> accumulator() {
        return (node, v) -> node.add(this.serializer.apply(v));
    }

    @Override
    public BinaryOperator<JsonNode> combiner() {
        return JsonNode::append;
    }

    @Override
    public Function<JsonNode, JsonNode> finisher() {
        return Function.identity();
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACTERISTICS;
    }
}

