/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl;

import dev.runefox.json.JsonNode;
import dev.runefox.json.JsonSerializingConfig;
import dev.runefox.json.NodeType;
import dev.runefox.json.SerializationException;
import dev.runefox.json.impl.KotlinUnsignedIntWrapper;
import dev.runefox.json.impl.UnparsedHexNumber;
import dev.runefox.json.impl.UnparsedNumber;
import dev.runefox.json.impl.node.NumberNode;
import dev.runefox.json.impl.node.StringNode;
import dev.runefox.json.impl.parse.CharUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Serializer {
    private static final ThreadLocal<Serializer> SERIALIZER_INSTANCE = ThreadLocal.withInitial(Serializer::new);
    private Appendable output;
    private JsonSerializingConfig config;
    private int nextSpacing;
    private final Set<String> validIds = new HashSet<String>();
    private final Map<String, String> stringToJsonCache = new HashMap<String, String>();
    private final StringBuilder builder = new StringBuilder();
    private char quote;
    private int indent = 0;
    private static final Pattern TRAILING_ZERO_PATTERN = Pattern.compile("^(.*)\\.0+$");
    private static final Pattern TRAILING_ZERO_EXP_PATTERN = Pattern.compile("^(.*)\\.0+(e.*)$");

    public void reset(Appendable output, JsonSerializingConfig config) {
        this.builder.setLength(0);
        this.output = output;
        this.config = config;
        this.quote = (char)(config.useSingleQuoteStrings() && config.json5() ? 39 : 34);
        this.indent = 0;
        this.nextSpacing = 0;
    }

    private void addSpacing(int count) throws IOException {
        if (this.nextSpacing > count) {
            count = this.nextSpacing;
        }
        this.nextSpacing = 0;
        this.addSpaces(count);
    }

    private void addSpaces(int count) throws IOException {
        this.output.append(" ".repeat(count));
    }

    private void addTabs(int count) throws IOException {
        this.output.append("\t".repeat(count));
    }

    private void addNewline() throws IOException {
        this.output.append(this.config.lineSeparator().toString());
        this.addIndent(this.indent);
    }

    private void addIndent(int count) throws IOException {
        if (this.config.tabIndent()) {
            this.addTabs(this.config.indent() * count);
        } else {
            this.addSpaces(this.config.indent() * count);
        }
        this.nextSpacing = 0;
    }

    private String stringToJson(String str) {
        if (this.stringToJsonCache.containsKey(str)) {
            return this.stringToJsonCache.get(str);
        }
        this.builder.setLength(0);
        StringNode.quote(str, this.builder, this.quote);
        String converted = this.builder.toString();
        this.stringToJsonCache.put(str, converted);
        return converted;
    }

    private String keyToJson(String str) {
        if (this.config.json5() && this.config.useIdentifierKeys()) {
            if (this.validIds.contains(str)) {
                return str;
            }
            if (CharUtil.isIdentifierValid(str)) {
                this.validIds.add(str);
                return str;
            }
        }
        return this.stringToJson(str);
    }

    private int getObjectKeyAlignmentLength(JsonNode object) {
        if (!this.config.alignObjectValues()) {
            return 0;
        }
        int len = 0;
        for (String key : object.keySet()) {
            String jsonKey = this.keyToJson(key);
            len = Math.max(len, jsonKey.length());
        }
        return len;
    }

    private void writeString(String str) throws IOException {
        this.addSpacing(0);
        this.output.append(this.stringToJson(str));
    }

    private void writeNumber(NumberNode number) throws IOException {
        switch (number.finiteness()) {
            case FINITE: {
                this.writeFiniteNumber(number.asNumber(), number);
                break;
            }
            case NAN: {
                this.writeNonFiniteNumber("NaN");
                break;
            }
            case POSITIVE_INFINITE: {
                this.writeNonFiniteNumber("Infinity");
                break;
            }
            case NEGATIVE_INFINITE: {
                this.writeNonFiniteNumber("-Infinity");
            }
        }
    }

    private void writeNonFiniteNumber(String value) throws IOException {
        if (!this.config.json5() || !this.config.allowNonFiniteNumbers()) {
            throw new IOException("Cannot serialize " + value + " as non-finite numbers are not supported");
        }
        this.output.append(value);
    }

    private void writeFiniteNumber(Number number, NumberNode node) throws IOException {
        String str;
        this.addSpacing(0);
        if (number instanceof UnparsedNumber) {
            UnparsedNumber un = (UnparsedNumber)number;
            str = un.toJsonValidString().toLowerCase();
        } else if (number instanceof UnparsedHexNumber) {
            UnparsedHexNumber uhn = (UnparsedHexNumber)number;
            str = uhn.toJsonValidString().toLowerCase();
        } else if (number instanceof KotlinUnsignedIntWrapper) {
            KotlinUnsignedIntWrapper kuiw = (KotlinUnsignedIntWrapper)number;
            str = kuiw.represent().toLowerCase();
        } else {
            str = node.asBigDecimal().toString().toLowerCase();
        }
        if (this.config.enforcePointInNumbers()) {
            if (!str.contains(".") && !str.contains("e")) {
                this.output.append(str).append(".0");
            } else if (!str.contains(".") && str.contains("e")) {
                this.output.append(str.replace("e", ".0e"));
            } else {
                this.output.append(str);
            }
        } else {
            Matcher m = TRAILING_ZERO_PATTERN.matcher(str);
            if (m.matches()) {
                this.output.append(m.group(1));
            } else {
                m = TRAILING_ZERO_EXP_PATTERN.matcher(str);
                if (m.matches()) {
                    this.output.append(m.group(1)).append(m.group(2));
                } else {
                    this.output.append(str);
                }
            }
        }
    }

    private void writeBoolean(boolean bool) throws IOException {
        this.addSpacing(0);
        this.output.append(bool ? "true" : "false");
    }

    private void writeNull() throws IOException {
        this.addSpacing(0);
        this.output.append("null");
    }

    private void writeComma() throws IOException {
        this.addSpacing(this.config.spacesBeforeComma());
        this.output.append(",");
        this.nextSpacing = this.config.spacesAfterComma();
    }

    private void writeColon() throws IOException {
        this.addSpacing(this.config.spacesBeforeColon());
        this.output.append(":");
        this.nextSpacing = this.config.spacesAfterColon();
    }

    private void writeArray(JsonNode array) throws IOException {
        if (array.size() == 0) {
            this.addSpacing(this.config.spacesAroundArray());
            this.output.append('[');
            this.addSpacing(this.config.spacesWithinEmptyArray());
            this.output.append(']');
            this.nextSpacing = this.config.spacesAroundArray();
        } else {
            this.addSpacing(this.config.spacesAroundArray());
            this.output.append('[');
            this.nextSpacing = this.config.spacesWithinArray();
            boolean wrap = this.config.shouldWrap(array);
            if (wrap) {
                ++this.indent;
                this.addNewline();
            }
            int size = array.size();
            for (JsonNode node : array) {
                this.writeValue(node);
                if (size != 1 || this.config.json5() && this.config.addTrailingComma()) {
                    this.writeComma();
                }
                if (size != 1 && wrap) {
                    this.addNewline();
                }
                --size;
            }
            this.nextSpacing = Math.max(this.nextSpacing, this.config.spacesWithinArray());
            if (wrap) {
                --this.indent;
                this.addNewline();
            }
            this.addSpacing(0);
            this.output.append(']');
            this.nextSpacing = this.config.spacesAroundArray();
        }
    }

    private void writeObject(JsonNode object) throws IOException {
        if (object.size() == 0) {
            this.addSpacing(this.config.spacesAroundObject());
            this.output.append('{');
            this.addSpacing(this.config.spacesWithinEmptyObject());
            this.output.append('}');
            this.nextSpacing = this.config.spacesAroundObject();
        } else {
            this.addSpacing(this.config.spacesAroundObject());
            this.output.append('{');
            this.nextSpacing = this.config.spacesWithinObject();
            int alignmentLen = this.getObjectKeyAlignmentLength(object);
            boolean wrap = this.config.shouldWrap(object);
            if (wrap) {
                ++this.indent;
                this.addNewline();
            }
            int size = object.size();
            for (String key : object.keySet()) {
                String jsonKey = this.keyToJson(key);
                this.writeAlignedKey(jsonKey, alignmentLen);
                this.writeValue(object.get(key));
                if (size != 1 || this.config.json5() && this.config.addTrailingComma()) {
                    this.writeComma();
                }
                if (size != 1 && wrap) {
                    this.addNewline();
                }
                --size;
            }
            this.nextSpacing = Math.max(this.nextSpacing, this.config.spacesWithinObject());
            if (wrap) {
                --this.indent;
                this.addNewline();
            }
            this.addSpacing(0);
            this.output.append('}');
            this.nextSpacing = this.config.spacesAroundObject();
        }
    }

    private void writeAlignedKey(String key, int size) throws IOException {
        this.addSpacing(0);
        this.output.append(key);
        this.writeColon();
        if (!this.config.alignObjectValues()) {
            return;
        }
        int len = key.length();
        int remainingSpace = Math.max(size - len, 0);
        this.addSpaces(remainingSpace);
    }

    private void writeValue(JsonNode value) throws IOException {
        switch (value.type()) {
            case NULL: {
                this.writeNull();
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(value.asBoolean());
                break;
            }
            case NUMBER: {
                this.writeNumber((NumberNode)value);
                break;
            }
            case STRING: {
                this.writeString(value.asString());
                break;
            }
            case ARRAY: {
                this.writeArray(value);
                break;
            }
            case OBJECT: {
                this.writeObject(value);
            }
        }
    }

    public void writeJson(JsonNode node) throws IOException {
        if (this.config.makeNonExecutable()) {
            this.output.append(")]}'\n");
        }
        if (!this.config.anyValue() && !node.is(NodeType.ARRAY, NodeType.OBJECT)) {
            throw new SerializationException("JSON document must be array or object to serialize");
        }
        this.writeValue(node);
        if (this.config.newlineAtEnd()) {
            this.addNewline();
        }
        this.validIds.clear();
        this.stringToJsonCache.clear();
    }

    public static void serialize(JsonNode node, Appendable output, JsonSerializingConfig config) throws IOException {
        Serializer serializer = SERIALIZER_INSTANCE.get();
        serializer.reset(output, config);
        serializer.writeJson(node);
    }
}

