/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl;

import dev.runefox.json.impl.UnparsedHexNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public class UnparsedNumber
extends Number {
    private final String number;
    private String full;
    private String integral;
    private boolean hasValue;
    private double value;
    private boolean hasIntValue;
    private long intValue;
    private boolean hasUIntValue;
    private long uintValue;
    private BigInteger bigIntValue;
    private BigDecimal bigValue;
    private boolean isZero;
    private boolean isIntegral;

    public UnparsedNumber(String number) {
        this.number = number;
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    private String full() {
        boolean zero;
        Object full;
        boolean decimalZero;
        boolean integralZero;
        String exponent;
        Object integral;
        block26: {
            String decimal;
            block25: {
                if (this.full != null) {
                    return this.full;
                }
                integral = this.number.toLowerCase(Locale.ROOT);
                decimal = "";
                exponent = "";
                int dot = ((String)integral).indexOf(46);
                if (dot >= 0) {
                    String igr = integral;
                    integral = igr.substring(0, dot);
                    decimal = igr.substring(dot + 1);
                    int e = decimal.indexOf(101);
                    if (e >= 0) {
                        String dc = decimal;
                        decimal = dc.substring(0, e);
                        exponent = dc.substring(e + 1);
                    }
                } else {
                    int e = ((String)integral).indexOf(101);
                    if (e >= 0) {
                        String igr = integral;
                        integral = igr.substring(0, e);
                        exponent = igr.substring(e + 1);
                    }
                }
                integralZero = false;
                if (((String)integral).isEmpty()) {
                    integral = "0";
                    integralZero = true;
                }
                if (((String)integral).equals("-")) {
                    integral = "-0";
                    integralZero = true;
                }
                if (((String)integral).equals("+")) {
                    integral = "0";
                    integralZero = true;
                }
                if (!integralZero) {
                    int s = 0;
                    if (((String)integral).startsWith("-") || ((String)integral).startsWith("+")) {
                        s = 1;
                    }
                    int l = ((String)integral).length();
                    for (int i = s; i < l; ++i) {
                        if (((String)integral).charAt(i) == '0') {
                            continue;
                        }
                        break block25;
                    }
                    integralZero = true;
                }
            }
            decimalZero = true;
            full = integral;
            if (!decimal.isEmpty()) {
                full = (String)full + "." + decimal;
                decimalZero = false;
            }
            if (!decimalZero) {
                int l = decimal.length();
                for (int i = 0; i < l; ++i) {
                    if (decimal.charAt(i) == '0') {
                        continue;
                    }
                    break block26;
                }
                decimalZero = true;
            }
        }
        if (!exponent.isEmpty()) {
            if (exponent.equals("-")) {
                exponent = "-0";
            }
            if (exponent.equals("+")) {
                exponent = "0";
            }
            full = (String)full + "e" + exponent;
        }
        boolean bl = zero = integralZero && decimalZero;
        if (!zero) {
            if (!exponent.isEmpty()) {
                BigInteger i = new BigInteger(exponent);
                int comp = i.compareTo(BigInteger.ZERO);
                if (comp < 0) {
                    integral = null;
                } else if (comp > 0 && i.compareTo(BigInteger.TEN) <= 0) {
                    integral = (String)integral + "0".repeat(i.intValue());
                }
            }
        } else {
            integral = "0";
            this.bigIntValue = BigInteger.ZERO;
            this.bigValue = BigDecimal.ZERO;
            this.value = 0.0;
            this.hasValue = true;
            this.intValue = 0L;
            this.hasIntValue = true;
            this.uintValue = 0L;
            this.hasUIntValue = true;
        }
        this.full = full;
        this.integral = integral;
        this.isZero = integralZero && decimalZero;
        this.isIntegral = decimalZero;
        return full;
    }

    boolean isZero() {
        this.full();
        return this.isZero;
    }

    boolean isIntegral() {
        this.full();
        return this.isIntegral;
    }

    String integral() {
        if (this.integral == null) {
            this.full();
        }
        return this.integral;
    }

    public long unsignedLongValue() {
        if (!this.hasUIntValue) {
            try {
                String i = this.integral();
                this.uintValue = i == null ? this.bigDecimalValue().longValue() : Long.parseUnsignedLong(i);
            }
            catch (NumberFormatException exc) {
                this.uintValue = 0L;
            }
            this.hasUIntValue = true;
        }
        return this.uintValue;
    }

    @Override
    public long longValue() {
        if (!this.hasIntValue) {
            try {
                String i = this.integral();
                this.intValue = i == null ? this.bigDecimalValue().longValue() : Long.parseLong(i);
            }
            catch (NumberFormatException exc) {
                this.intValue = 0L;
            }
            this.hasIntValue = true;
        }
        return this.intValue;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        if (!this.hasValue) {
            try {
                this.value = Double.parseDouble(this.full());
            }
            catch (NumberFormatException exc) {
                this.value = Double.NaN;
            }
            this.hasValue = true;
        }
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        if (this.bigIntValue == null) {
            try {
                String i = this.integral();
                this.bigIntValue = i == null ? this.bigDecimalValue().toBigInteger() : new BigInteger(i);
            }
            catch (NumberFormatException exc) {
                this.bigIntValue = BigInteger.ZERO;
            }
        }
        return this.bigIntValue;
    }

    public BigDecimal bigDecimalValue() {
        if (this.bigValue == null) {
            try {
                this.bigValue = new BigDecimal(this.full());
            }
            catch (NumberFormatException exc) {
                this.bigValue = BigDecimal.ZERO;
            }
        }
        return this.bigValue;
    }

    public String toString() {
        return this.number;
    }

    public String toJsonValidString() {
        return new BigDecimal(this.full()).toString().toLowerCase(Locale.ROOT);
    }

    public static boolean isZero(Number number) {
        if (number instanceof UnparsedNumber) {
            return ((UnparsedNumber)number).isZero();
        }
        if (number instanceof UnparsedHexNumber) {
            return ((UnparsedHexNumber)number).isZero();
        }
        if (number instanceof BigInteger) {
            return number.equals(BigInteger.ZERO);
        }
        if (number instanceof BigDecimal) {
            return number.equals(BigDecimal.ZERO);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return number.intValue() == 0;
        }
        if (number instanceof Long) {
            return number.longValue() == 0L;
        }
        if (number instanceof Float) {
            return number.floatValue() == 0.0f;
        }
        return number.doubleValue() == 0.0;
    }
}

