/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.node;

import dev.runefox.json.IncorrectSizeException;
import dev.runefox.json.IncorrectTypeException;
import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeType;
import dev.runefox.json.impl.Internal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractJsonNode
implements JsonNode {
    private final NodeType type;

    protected AbstractJsonNode(NodeType type) {
        this.type = type;
    }

    @Override
    public NodeType type() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return this.is(NodeType.NULL);
    }

    @Override
    public boolean isString() {
        return this.is(NodeType.STRING);
    }

    @Override
    public boolean isNumber() {
        return this.is(NodeType.NUMBER);
    }

    @Override
    public boolean isBoolean() {
        return this.is(NodeType.BOOLEAN);
    }

    @Override
    public boolean isObject() {
        return this.is(NodeType.OBJECT);
    }

    @Override
    public boolean isArray() {
        return this.is(NodeType.ARRAY);
    }

    @Override
    public boolean is(NodeType type) {
        return type == this.type;
    }

    @Override
    public boolean is(NodeType ... types) {
        for (NodeType type : types) {
            if (!this.is(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JsonNode requireNull() {
        this.require(NodeType.NULL);
        return this;
    }

    @Override
    public JsonNode requireNotNull() {
        this.requireNot(NodeType.NULL);
        return this;
    }

    @Override
    public JsonNode requireString() {
        this.require(NodeType.STRING);
        return this;
    }

    @Override
    public JsonNode requireNotString() {
        this.requireNot(NodeType.STRING);
        return this;
    }

    @Override
    public JsonNode requireNumber() {
        this.require(NodeType.NUMBER);
        return this;
    }

    @Override
    public JsonNode requireNotNumber() {
        this.requireNot(NodeType.NUMBER);
        return this;
    }

    @Override
    public JsonNode requireBoolean() {
        this.require(NodeType.BOOLEAN);
        return this;
    }

    @Override
    public JsonNode requireNotBoolean() {
        this.requireNot(NodeType.BOOLEAN);
        return this;
    }

    @Override
    public JsonNode requireObject() {
        this.require(NodeType.OBJECT);
        return this;
    }

    @Override
    public JsonNode requireNotObject() {
        this.requireNot(NodeType.OBJECT);
        return this;
    }

    @Override
    public JsonNode requireArray() {
        this.require(NodeType.ARRAY);
        return this;
    }

    @Override
    public JsonNode requireNotArray() {
        this.requireNot(NodeType.ARRAY);
        return this;
    }

    @Override
    public JsonNode require(NodeType type) {
        if (!this.is(type)) {
            throw new IncorrectTypeException(this.type, type);
        }
        return this;
    }

    @Override
    public JsonNode requireNot(NodeType type) {
        if (this.is(type)) {
            throw new IncorrectTypeException(this.type, Internal.allExcluding0(type));
        }
        return this;
    }

    @Override
    public JsonNode require(NodeType ... types) {
        if (!this.is(types)) {
            throw new IncorrectTypeException(this.type, types);
        }
        return this;
    }

    @Override
    public JsonNode requireNot(NodeType ... types) {
        if (this.is(types)) {
            throw new IncorrectTypeException(Internal.makeMessageInv(this.type, types));
        }
        return this;
    }

    @Override
    public JsonNode ifString(BiConsumer<JsonNode, String> action) {
        return this;
    }

    @Override
    public JsonNode ifNumber(BiConsumer<JsonNode, Number> action) {
        return this;
    }

    @Override
    public JsonNode ifByte(BiConsumer<JsonNode, Byte> action) {
        return this;
    }

    @Override
    public JsonNode ifShort(BiConsumer<JsonNode, Short> action) {
        return this;
    }

    @Override
    public JsonNode ifInt(BiConsumer<JsonNode, Integer> action) {
        return this;
    }

    @Override
    public JsonNode ifLong(BiConsumer<JsonNode, Long> action) {
        return this;
    }

    @Override
    public JsonNode ifFloat(BiConsumer<JsonNode, Float> action) {
        return this;
    }

    @Override
    public JsonNode ifDouble(BiConsumer<JsonNode, Double> action) {
        return this;
    }

    @Override
    public JsonNode ifBigInteger(BiConsumer<JsonNode, BigInteger> action) {
        return this;
    }

    @Override
    public JsonNode ifBigDecimal(BiConsumer<JsonNode, BigDecimal> action) {
        return this;
    }

    @Override
    public JsonNode ifBoolean(BiConsumer<JsonNode, Boolean> action) {
        return this;
    }

    @Override
    public JsonNode ifNull(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifArray(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifObject(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifPrimitive(Consumer<JsonNode> action) {
        return this;
    }

    @Override
    public JsonNode ifConstruct(Consumer<JsonNode> action) {
        return this;
    }

    private static void require(int i, JsonNode node, NodeType type) {
        if (!node.is(type)) {
            throw new IncorrectTypeException(i, node.type(), type);
        }
    }

    @Override
    public String[] asStringArray() {
        this.requireArray();
        int l = this.size();
        String[] arr = new String[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.STRING);
            arr[i] = this.get(i).asExactString();
        }
        return arr;
    }

    @Override
    public byte[] asByteArray() {
        this.requireArray();
        int l = this.size();
        byte[] arr = new byte[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asByte();
        }
        return arr;
    }

    @Override
    public short[] asShortArray() {
        this.requireArray();
        int l = this.size();
        short[] arr = new short[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asShort();
        }
        return arr;
    }

    @Override
    public int[] asIntArray() {
        this.requireArray();
        int l = this.size();
        int[] arr = new int[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asInt();
        }
        return arr;
    }

    @Override
    public long[] asLongArray() {
        this.requireArray();
        int l = this.size();
        long[] arr = new long[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asLong();
        }
        return arr;
    }

    @Override
    public float[] asFloatArray() {
        this.requireArray();
        int l = this.size();
        float[] arr = new float[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asFloat();
        }
        return arr;
    }

    @Override
    public double[] asDoubleArray() {
        this.requireArray();
        int l = this.size();
        double[] arr = new double[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asDouble();
        }
        return arr;
    }

    @Override
    public BigInteger[] asBigIntegerArray() {
        this.requireArray();
        int l = this.size();
        BigInteger[] arr = new BigInteger[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asBigInteger();
        }
        return arr;
    }

    @Override
    public BigDecimal[] asBigDecimalArray() {
        this.requireArray();
        int l = this.size();
        BigDecimal[] arr = new BigDecimal[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asBigDecimal();
        }
        return arr;
    }

    @Override
    public Number[] asNumberArray() {
        this.requireArray();
        int l = this.size();
        Number[] arr = new Number[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.NUMBER);
            arr[i] = this.get(i).asNumber();
        }
        return arr;
    }

    @Override
    public boolean[] asBooleanArray() {
        this.requireArray();
        int l = this.size();
        boolean[] arr = new boolean[l];
        for (int i = 0; i < l; ++i) {
            JsonNode element = this.get(i);
            AbstractJsonNode.require(i, element, NodeType.BOOLEAN);
            arr[i] = this.get(i).asBoolean();
        }
        return arr;
    }

    @Override
    public JsonNode requireSize(int length) {
        this.require(NodeType.ARRAY, NodeType.OBJECT);
        int s = this.size();
        if (s != length) {
            throw new IncorrectSizeException(s, length);
        }
        return this;
    }

    @Override
    public JsonNode requireMinSize(int length) {
        this.require(NodeType.ARRAY, NodeType.OBJECT);
        int s = this.size();
        if (s < length) {
            throw new IncorrectSizeException(s, length);
        }
        return this;
    }

    @Override
    public JsonNode requireMaxSize(int length) {
        this.require(NodeType.ARRAY, NodeType.OBJECT);
        int s = this.size();
        if (s > length) {
            throw new IncorrectSizeException(s, length);
        }
        return this;
    }

    @Override
    public JsonNode requireSize(int min, int max) {
        this.require(NodeType.ARRAY, NodeType.OBJECT);
        int s = this.size();
        if (s < min || s > max) {
            throw new IncorrectSizeException(s, min, max);
        }
        return this;
    }

    @Override
    public String[] asStringArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asStringArray();
    }

    @Override
    public byte[] asByteArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asByteArray();
    }

    @Override
    public short[] asShortArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asShortArray();
    }

    @Override
    public int[] asIntArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asIntArray();
    }

    @Override
    public long[] asLongArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asLongArray();
    }

    @Override
    public float[] asFloatArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asFloatArray();
    }

    @Override
    public double[] asDoubleArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asDoubleArray();
    }

    @Override
    public BigInteger[] asBigIntegerArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBigIntegerArray();
    }

    @Override
    public BigDecimal[] asBigDecimalArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBigDecimalArray();
    }

    @Override
    public Number[] asNumberArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asNumberArray();
    }

    @Override
    public boolean[] asBooleanArray(int fixedLength) {
        this.requireArray();
        this.requireSize(fixedLength);
        return this.asBooleanArray();
    }

    @Override
    public List<JsonNode> asList() {
        throw new IncorrectTypeException(this.type, NodeType.ARRAY);
    }

    @Override
    public Map<String, JsonNode> asMap() {
        throw new IncorrectTypeException(this.type, NodeType.OBJECT);
    }

    @Override
    public JsonNode wrap() {
        return JsonNode.array((JsonNode)this);
    }

    @Override
    public JsonNode wrap(String key) {
        JsonNode obj = JsonNode.object();
        obj.set(key, (JsonNode)this);
        return obj;
    }
}

