/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.node;

import dev.runefox.json.IncorrectTypeException;
import dev.runefox.json.JsonNode;
import dev.runefox.json.NodeType;
import dev.runefox.json.impl.KotlinUnsignedIntWrapper;
import dev.runefox.json.impl.UnparsedHexNumber;
import dev.runefox.json.impl.UnparsedNumber;
import dev.runefox.json.impl.node.AbstractPrimitiveNode;
import dev.runefox.json.impl.node.Finiteness;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class NumberNode
extends AbstractPrimitiveNode {
    private static final int NAN_HASH = 8811;
    private static final int POSITIVE_INFINITY_HASH = 11579;
    private static final int NEGATIVE_INFINITY_HASH = 10082;
    private final Number number;
    private BigInteger bigInteger;
    private BigDecimal bigDecimal;
    private String string;

    public NumberNode(Number number) {
        super(NodeType.NUMBER);
        this.number = number;
    }

    @Override
    public JsonNode ifNumber(BiConsumer<JsonNode, Number> action) {
        action.accept(this, this.number);
        return this;
    }

    @Override
    public JsonNode ifByte(BiConsumer<JsonNode, Byte> action) {
        action.accept(this, this.asByte());
        return this;
    }

    @Override
    public JsonNode ifShort(BiConsumer<JsonNode, Short> action) {
        action.accept(this, this.asShort());
        return this;
    }

    @Override
    public JsonNode ifInt(BiConsumer<JsonNode, Integer> action) {
        action.accept(this, this.asInt());
        return this;
    }

    @Override
    public JsonNode ifLong(BiConsumer<JsonNode, Long> action) {
        action.accept(this, this.asLong());
        return this;
    }

    @Override
    public JsonNode ifFloat(BiConsumer<JsonNode, Float> action) {
        action.accept(this, Float.valueOf(this.asFloat()));
        return this;
    }

    @Override
    public JsonNode ifDouble(BiConsumer<JsonNode, Double> action) {
        action.accept(this, this.asDouble());
        return this;
    }

    @Override
    public JsonNode ifBigInteger(BiConsumer<JsonNode, BigInteger> action) {
        action.accept(this, this.asBigInteger());
        return this;
    }

    @Override
    public JsonNode ifBigDecimal(BiConsumer<JsonNode, BigDecimal> action) {
        action.accept(this, this.asBigDecimal());
        return this;
    }

    @Override
    public String asExactString() {
        throw new IncorrectTypeException(NodeType.NUMBER, NodeType.STRING);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public byte asByte() {
        return this.number.byteValue();
    }

    @Override
    public short asShort() {
        return this.number.shortValue();
    }

    @Override
    public int asInt() {
        return this.number.intValue();
    }

    @Override
    public long asLong() {
        return this.number.longValue();
    }

    @Override
    public float asFloat() {
        return this.number.floatValue();
    }

    @Override
    public double asDouble() {
        return this.number.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.bigInteger != null) {
            return this.bigInteger;
        }
        Number number = this.number;
        if (number instanceof BigInteger) {
            BigInteger bi;
            this.bigInteger = bi = (BigInteger)number;
            return this.bigInteger;
        }
        number = this.number;
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            this.bigInteger = bd.toBigInteger();
            return this.bigInteger;
        }
        number = this.number;
        if (number instanceof UnparsedNumber) {
            UnparsedNumber un = (UnparsedNumber)number;
            this.bigInteger = un.bigIntegerValue();
            return this.bigInteger;
        }
        number = this.number;
        if (number instanceof UnparsedHexNumber) {
            UnparsedHexNumber uhn = (UnparsedHexNumber)number;
            this.bigInteger = uhn.bigIntegerValue();
            return this.bigInteger;
        }
        number = this.number;
        if (number instanceof KotlinUnsignedIntWrapper) {
            KotlinUnsignedIntWrapper knw = (KotlinUnsignedIntWrapper)number;
            this.bigInteger = knw.toBigInteger();
            return this.bigInteger;
        }
        if (this.finiteness() != Finiteness.FINITE) {
            this.bigInteger = BigInteger.ZERO;
            return this.bigInteger;
        }
        this.bigInteger = this.asBigDecimal().toBigInteger();
        return this.bigInteger;
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (this.bigDecimal != null) {
            return this.bigDecimal;
        }
        Number number = this.number;
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            this.bigDecimal = new BigDecimal(bi);
            return this.bigDecimal;
        }
        number = this.number;
        if (number instanceof BigDecimal) {
            BigDecimal bd;
            this.bigDecimal = bd = (BigDecimal)number;
            return this.bigDecimal;
        }
        number = this.number;
        if (number instanceof UnparsedNumber) {
            UnparsedNumber un = (UnparsedNumber)number;
            this.bigDecimal = un.bigDecimalValue();
            return this.bigDecimal;
        }
        number = this.number;
        if (number instanceof UnparsedHexNumber) {
            UnparsedHexNumber uhn = (UnparsedHexNumber)number;
            this.bigDecimal = uhn.bigDecimalValue();
            return this.bigDecimal;
        }
        number = this.number;
        if (number instanceof KotlinUnsignedIntWrapper) {
            KotlinUnsignedIntWrapper knw = (KotlinUnsignedIntWrapper)number;
            this.bigDecimal = knw.toBigDecimal();
            return this.bigDecimal;
        }
        if (this.finiteness() != Finiteness.FINITE) {
            this.bigDecimal = BigDecimal.ZERO;
            return this.bigDecimal;
        }
        this.bigDecimal = BigDecimal.valueOf(this.asDouble());
        return this.bigDecimal;
    }

    @Override
    public Number asNumber() {
        return this.number;
    }

    @Override
    public boolean asBoolean() {
        throw new IncorrectTypeException(NodeType.NUMBER, NodeType.BOOLEAN);
    }

    public Finiteness finiteness() {
        Number number = this.number;
        if (number instanceof Double) {
            Double d = (Double)number;
            if (d.isNaN()) {
                return Finiteness.NAN;
            }
            if (d.isInfinite()) {
                return d < 0.0 ? Finiteness.NEGATIVE_INFINITE : Finiteness.POSITIVE_INFINITE;
            }
        }
        if ((number = this.number) instanceof Float) {
            Float f = (Float)number;
            if (f.isNaN()) {
                return Finiteness.NAN;
            }
            if (f.isInfinite()) {
                return f.floatValue() < 0.0f ? Finiteness.NEGATIVE_INFINITE : Finiteness.POSITIVE_INFINITE;
            }
        }
        return Finiteness.FINITE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberNode other = (NumberNode)o;
        Finiteness finiteness = this.finiteness();
        if (!finiteness.equals((Object)other.finiteness())) {
            return false;
        }
        if (finiteness != Finiteness.FINITE) {
            return true;
        }
        return this.asBigDecimal().equals(other.asBigDecimal());
    }

    public int hashCode() {
        Finiteness finiteness = this.finiteness();
        return switch (finiteness) {
            default -> throw new IncompatibleClassChangeError();
            case Finiteness.FINITE -> Objects.hash(this.asBigDecimal());
            case Finiteness.NAN -> 8811;
            case Finiteness.POSITIVE_INFINITE -> 11579;
            case Finiteness.NEGATIVE_INFINITE -> 10082;
        };
    }

    public String toString() {
        if (this.string != null) {
            return this.string;
        }
        Object object = this.number;
        if (object instanceof KotlinUnsignedIntWrapper) {
            KotlinUnsignedIntWrapper knw = (KotlinUnsignedIntWrapper)object;
            this.string = knw.represent();
            return this.string;
        }
        object = this.number;
        if (object instanceof UnparsedNumber) {
            UnparsedNumber un = (UnparsedNumber)object;
            this.string = un.toJsonValidString();
            return this.string;
        }
        object = this.number;
        if (object instanceof UnparsedHexNumber) {
            UnparsedHexNumber uhn = (UnparsedHexNumber)object;
            this.string = uhn.toJsonValidString();
            return this.string;
        }
        NumberNode numberNode = this;
        Object object2 = switch (this.finiteness()) {
            default -> throw new IncompatibleClassChangeError();
            case Finiteness.FINITE -> {
                NumberNode v0;
                BigDecimal decimal = this.asBigDecimal();
                try {
                    BigInteger integer = decimal.toBigIntegerExact();
                    object = integer.toString();
                    v0 = numberNode;
                    yield object;
                }
                catch (ArithmeticException exc) {
                    object = decimal.toString();
                    v0 = numberNode;
                    yield object;
                }
            }
            case Finiteness.NAN -> {
                object = "NaN";
                NumberNode v0 = numberNode;
                yield object;
            }
            case Finiteness.POSITIVE_INFINITE -> {
                object = "Infinity";
                NumberNode v0 = numberNode;
                yield object;
            }
            case Finiteness.NEGATIVE_INFINITE -> {
                object = "-Infinity";
                NumberNode v0 = numberNode;
                yield object;
            }
        };
        v0.string = object2;
        return object2;
    }
}

