/*
 * Decompiled with CFR 0.152.
 */
package dev.runefox.json.impl.parse.json;

import dev.runefox.json.SyntaxException;
import dev.runefox.json.impl.parse.AbstractLexer;
import dev.runefox.json.impl.parse.Token;
import dev.runefox.json.impl.parse.json.JsonReader;
import dev.runefox.json.impl.parse.json.JsonTokenType;
import java.io.IOException;

public class JsonLexerReader
implements JsonReader {
    private final Token nextToken = new Token();
    private boolean hasNext;
    private final AbstractLexer lexer;

    public JsonLexerReader(AbstractLexer lexer, boolean skipNonExecute) throws IOException {
        this.lexer = lexer;
        if (skipNonExecute) {
            lexer.skipNonExecutePrefixes();
        }
    }

    private Token next() throws IOException {
        if (!this.hasNext) {
            this.lexer.token(this.nextToken);
            this.hasNext = true;
        }
        return this.nextToken;
    }

    private Token next(JsonTokenType expectedType) throws IOException {
        Token next = this.next();
        JsonTokenType nextType = (JsonTokenType)next.type();
        if (nextType == expectedType) {
            return next;
        }
        throw next.error("Expected " + expectedType.getErrorName());
    }

    @Override
    public boolean readBoolean() throws IOException {
        Token next = this.next(JsonTokenType.BOOLEAN);
        this.hasNext = false;
        return (Boolean)next.value();
    }

    @Override
    public String readString() throws IOException {
        Token next = this.next(JsonTokenType.STRING);
        this.hasNext = false;
        return (String)next.value();
    }

    @Override
    public String readIdentifier() throws IOException {
        Token next = this.next(JsonTokenType.IDENTIFIER);
        this.hasNext = false;
        return (String)next.value();
    }

    @Override
    public Number readNumber() throws IOException {
        Token next = this.next(JsonTokenType.NUMBER);
        this.hasNext = false;
        return (Number)next.value();
    }

    @Override
    public void readNull() throws IOException {
        this.next(JsonTokenType.NULL);
        this.hasNext = false;
    }

    @Override
    public void readObjectStart() throws IOException {
        this.next(JsonTokenType.OBJECT_START);
        this.hasNext = false;
    }

    @Override
    public void readObjectEnd() throws IOException {
        this.next(JsonTokenType.OBJECT_END);
        this.hasNext = false;
    }

    @Override
    public void readArrayStart() throws IOException {
        this.next(JsonTokenType.ARRAY_START);
        this.hasNext = false;
    }

    @Override
    public void readArrayEnd() throws IOException {
        this.next(JsonTokenType.ARRAY_END);
        this.hasNext = false;
    }

    @Override
    public void readColon() throws IOException {
        this.next(JsonTokenType.COLON);
        this.hasNext = false;
    }

    @Override
    public void readComma() throws IOException {
        this.next(JsonTokenType.COMMA);
        this.hasNext = false;
    }

    @Override
    public JsonTokenType peekToken() throws IOException {
        return (JsonTokenType)this.next().type();
    }

    @Override
    public void readToken() throws IOException {
        this.next();
        this.hasNext = false;
    }

    @Override
    public void close() throws IOException {
        this.lexer.close();
    }

    @Override
    public SyntaxException error(String message) {
        if (this.hasNext) {
            return this.nextToken.error(message);
        }
        return this.lexer.error(message);
    }
}

